/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.seed;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.buildrun.seeddata.api.vo.FieldData;
import io.buildrun.seeddata.api.vo.RecordData;
import io.buildrun.seeddata.api.vo.SeedData;
import io.buildrun.seeddata.api.vo.ServiceData;
import io.buildrun.seeddata.api.vo.TableData;
import io.buildrun.seeddata.app.service.impl.SeedDataProcessorImpl;
import io.choerodon.liquibase.addition.AdditionDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedDataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeedDataLoader.class);
    private static final XmlMapper XML_MAPPER = new XmlMapper();
    private String serviceCode;
    private Map<String, RecordData> waitingExternals = new HashMap<String, RecordData>();
    private Map<String, RecordData> allExternals = new HashMap<String, RecordData>();

    public SeedDataLoader(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public void execute(InputStream inputStream, AdditionDataSource ad) throws CustomChangeException {
        try (Connection connection = ad.getDataSource().getConnection();){
            SeedData seedData = (SeedData)XML_MAPPER.readValue(inputStream, SeedData.class);
            ServiceData service = seedData.getServices(this.serviceCode);
            if (service != null) {
                this.processService(service, ad.getDataSource());
            }
        }
        catch (IOException | SQLException e) {
            throw new CustomChangeException((Throwable)e);
        }
    }

    private void processService(ServiceData service, DataSource dataSource) {
        String targetService = service.getName();
        for (TableData tableData : service.getTables()) {
            String targetTable = tableData.getName();
            for (RecordData recordData : tableData.getRecords()) {
                this.processRecordData(targetService, targetTable, recordData);
            }
        }
        this.processExternal(dataSource, targetService);
    }

    private void processRecordData(String targetService, String targetTable, RecordData recordData) {
        String externalId = this.makeExternalId(targetService, targetTable, recordData);
        recordData.setTable(targetTable);
        this.waitingExternals.put(externalId, recordData);
        this.allExternals.put(externalId, recordData);
    }

    private void processExternal(DataSource dataSource, String service) {
        int processedRecordCount;
        while ((processedRecordCount = this.processExternalOnce(dataSource, service)) != 0) {
        }
    }

    private int processExternalOnce(DataSource dataSource, String service) {
        int processedRecordCount = 0;
        int allProcessedRecordCount = 0;
        HashMap externalsMapping = new HashMap();
        HashMap serviceExternals = new HashMap();
        List<RecordData> records = this.resolveDependency(this.allExternals, this.waitingExternals.values());
        SeedDataProcessorImpl processor = new SeedDataProcessorImpl();
        List processedRecords = processor.processRecords(records, dataSource);
        for (RecordData processedRecord : processedRecords) {
            String externalId = this.makeExternalId(service, processedRecord.getTable(), processedRecord);
            RecordData processedExternal = this.waitingExternals.get(externalId);
            if (processedExternal != null) {
                this.waitingExternals.remove(externalId);
                this.allExternals.replace(externalId, processedExternal);
                ++processedRecordCount;
                continue;
            }
            LOGGER.warn("Seed data record process response external '{}' not found.", (Object)externalId);
        }
        LOGGER.info("Seed data process summary All/Processed/ProcessedOnOnce : {}/{}/{}", new Object[]{this.allExternals.size(), allProcessedRecordCount + processedRecordCount, processedRecordCount});
        return processedRecordCount;
    }

    private List<RecordData> resolveDependency(Map<String, RecordData> processedExternals, Collection<RecordData> externals) {
        LinkedList<RecordData> result = new LinkedList<RecordData>();
        for (RecordData record : externals) {
            boolean dependencySatisfy = true;
            Iterator fieldIterator = record.getFields().iterator();
            while (fieldIterator.hasNext()) {
                FieldData fieldData = (FieldData)fieldIterator.next();
                if (fieldData.getValue() != null) continue;
                if (fieldData.getRef() != null) {
                    String[] refs = fieldData.getRef().split(":");
                    String refExternalId = refs[0];
                    String refFieldName = refs[1];
                    RecordData refExternal = processedExternals.get(refExternalId);
                    if (refExternal != null && this.resolveExternalRecordValue(refExternal, refFieldName, fieldData)) continue;
                    dependencySatisfy = false;
                    break;
                }
                fieldIterator.remove();
            }
            if (!dependencySatisfy) continue;
            result.add(record);
        }
        return result;
    }

    private boolean resolveExternalRecordValue(RecordData record, String fieldName, FieldData target) {
        for (FieldData fieldData : record.getFields()) {
            if (!fieldName.equals(fieldData.getName()) || fieldData.getRef() != null) continue;
            target.setValue(fieldData.getValue());
            return true;
        }
        return false;
    }

    private String makeExternalId(String targetService, String targetTable, RecordData recordData) {
        if (recordData.getExternalId() == null) {
            LinkedList<String> uniques = new LinkedList<String>();
            for (FieldData fieldData : recordData.getFields()) {
                if (!Boolean.TRUE.equals(fieldData.getUnique()) || fieldData.getValue() == null) continue;
                uniques.add(fieldData.getValue());
            }
            recordData.setExternalId(String.join((CharSequence)"_", uniques));
        }
        return targetService + "." + targetTable + "." + recordData.getExternalId();
    }
}

