/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.utils;

import java.sql.JDBCType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import liquibase.util.StringUtil;

public class CellDataConverter {
    private static final int ISO_DATE_FORMATTER_LENGTH = 10;
    private static final String DECIMAL_POINT = ".";

    private CellDataConverter() {
    }

    public static Object covert(String value, String type) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        if (JDBCType.DATE.getName().equalsIgnoreCase(type)) {
            if (value.length() <= 10) {
                try {
                    return LocalDate.parse(value);
                }
                catch (DateTimeParseException e) {
                    try {
                        return new SimpleDateFormat("yyyy-MM-dd").parse(value);
                    }
                    catch (ParseException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            }
            try {
                return LocalDateTime.parse(value);
            }
            catch (DateTimeParseException e) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
                }
                catch (ParseException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        if (JDBCType.DECIMAL.getName().equalsIgnoreCase(type) || JDBCType.NUMERIC.getName().equalsIgnoreCase(type) || JDBCType.BIGINT.getName().equalsIgnoreCase(type)) {
            if (value.length() == 0) {
                return null;
            }
            if (value.contains(DECIMAL_POINT)) {
                return Double.parseDouble(value);
            }
            return Long.parseLong(value);
        }
        return value;
    }
}

