/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard;

import io.choerodon.asgard.common.ApplicationContextHelper;
import io.choerodon.asgard.property.PropertyData;
import io.choerodon.asgard.property.PropertyDataLoader;
import io.choerodon.asgard.property.PropertyDataProcessor;
import io.choerodon.asgard.saga.SagaProperties;
import io.choerodon.asgard.saga.consumer.SagaConsumer;
import io.choerodon.asgard.saga.consumer.SagaTaskProcessor;
import io.choerodon.asgard.saga.feign.SagaClient;
import io.choerodon.asgard.saga.feign.SagaClientCallback;
import io.choerodon.asgard.saga.feign.SagaConsumerClient;
import io.choerodon.asgard.saga.producer.ProducerBackCheckEndpoint;
import io.choerodon.asgard.saga.producer.TransactionalProducer;
import io.choerodon.asgard.saga.producer.TransactionalProducerImpl;
import io.choerodon.asgard.saga.producer.consistency.SagaProducerConsistencyHandler;
import io.choerodon.asgard.saga.producer.consistency.SagaProducerDbConsistencyHandler;
import io.choerodon.asgard.saga.producer.consistency.SagaProducerMemoryConsistencyHandler;
import io.choerodon.asgard.schedule.JobTaskProcessor;
import io.choerodon.asgard.schedule.ScheduleConsumer;
import io.choerodon.asgard.schedule.ScheduleProperties;
import io.choerodon.asgard.schedule.feign.ScheduleConsumerClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableFeignClients
@EnableConfigurationProperties(value={SagaProperties.class, ScheduleProperties.class})
@PropertySource(value={"classpath:buildrun-asgard-defualt-config.properties"})
public class AsgardAutoConfiguration {
    @Value(value="${spring.application.name}")
    private String service;

    @Bean
    public ApplicationContextHelper sagaApplicationContextHelper() {
        return new ApplicationContextHelper();
    }

    @Bean
    public PropertyData propertyData() {
        PropertyData propertyData = new PropertyData();
        propertyData.setService(this.service);
        return propertyData;
    }

    @Bean(name={"instance"})
    public String instance(Environment environment) throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress() + ":" + this.service + ":" + environment.getProperty("server.port");
    }

    @Bean
    public PropertyDataProcessor propertyDataProcessor() {
        return new PropertyDataProcessor(this.propertyData());
    }

    @Bean
    public PropertyDataLoader propertyDataLoader() {
        return new PropertyDataLoader(this.propertyData());
    }

    @Bean
    public SagaClientCallback sagaClientCallback() {
        return new SagaClientCallback();
    }

    static class SagaProducer {
        @Value(value="${spring.application.name}")
        private String service;

        SagaProducer() {
        }

        @Bean(name={"clearCacheScheduledService"})
        public ScheduledExecutorService sagaScheduledExecutorService() {
            return Executors.newScheduledThreadPool(1);
        }

        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="choerodon.saga.producer", name={"consistencyType"}, havingValue="memory", matchIfMissing=true)
        @Bean
        public SagaProducerMemoryConsistencyHandler memoryConsistencyHandler() {
            return new SagaProducerMemoryConsistencyHandler(this.sagaScheduledExecutorService());
        }

        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="choerodon.saga.producer", name={"consistencyType"}, havingValue="db", matchIfMissing=false)
        @Bean
        public SagaProducerDbConsistencyHandler dbConsistencyHandler(DataSource dataSource) {
            return new SagaProducerDbConsistencyHandler(this.sagaScheduledExecutorService(), dataSource);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="choerodon.saga.consumer", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ProducerBackCheckEndpoint sagaProducerBackCheckEndpoint(SagaProducerConsistencyHandler handler, SagaConsumer sagaConsumer) {
            return new ProducerBackCheckEndpoint(handler, sagaConsumer);
        }

        @Bean
        public TransactionalProducer transactionalProducer(PlatformTransactionManager transactionManager, SagaProducerConsistencyHandler consistencyHandler, SagaClient sagaClient) {
            return new TransactionalProducerImpl(transactionManager, consistencyHandler, sagaClient, this.service);
        }
    }

    @ConditionalOnProperty(prefix="choerodon.saga.consumer", name={"enabled"}, havingValue="true", matchIfMissing=true)
    static class SagaConsumerConfig {
        @Value(value="${spring.application.name}")
        private String service;
        private SagaProperties sagaProperties;

        public SagaConsumerConfig(SagaProperties sagaProperties) {
            this.sagaProperties = sagaProperties;
        }

        @Bean(name={"sagaScheduledExecutorService"})
        public ScheduledExecutorService sagaScheduledExecutorService() {
            return Executors.newScheduledThreadPool(1);
        }

        @Bean(name={"sagaExecutor"})
        public Executor sagaExecutor() {
            int coreSize = this.sagaProperties.getConsumer().getCoreThreadNum();
            if (coreSize <= 0) {
                return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            }
            return new ThreadPoolExecutor(coreSize, (int)this.sagaProperties.getConsumer().getMaxThreadNum(), 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(99999), new ThreadPoolExecutor.AbortPolicy());
        }

        @Bean
        public SagaTaskProcessor sagaTaskProcessor() {
            return new SagaTaskProcessor();
        }

        @Bean
        public SagaConsumer sagaMonitor(SagaConsumerClient sagaConsumerClient, @Qualifier(value="instance") String instance, DataSourceTransactionManager transactionManager, ApplicationContextHelper contextHelper) {
            SagaConsumer sagaConsumer = new SagaConsumer(this.service, instance, (PlatformTransactionManager)transactionManager, this.sagaExecutor(), this.sagaScheduledExecutorService(), contextHelper, this.sagaProperties.getConsumer().getPollIntervalMs());
            sagaConsumer.setConsumerClient(sagaConsumerClient);
            sagaConsumer.setProperties(this.sagaProperties);
            return sagaConsumer;
        }
    }

    @ConditionalOnProperty(prefix="choerodon.schedule.consumer", name={"enabled"}, havingValue="true", matchIfMissing=true)
    static class ScheduleConsumerConfig {
        private ScheduleProperties scheduleProperties;
        @Value(value="${spring.application.name}")
        private String service;

        public ScheduleConsumerConfig(ScheduleProperties scheduleProperties) {
            this.scheduleProperties = scheduleProperties;
        }

        @Bean(name={"quartzScheduledExecutorService"})
        public ScheduledExecutorService scheduledExecutorService() {
            return Executors.newScheduledThreadPool(1);
        }

        @Bean
        public JobTaskProcessor jobTaskProcessor() {
            return new JobTaskProcessor();
        }

        @Bean(name={"scheduleExecutor"})
        public Executor scheduleExecutor() {
            int coreSize = this.scheduleProperties.getCoreThreadNum();
            if (coreSize <= 0) {
                return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            }
            return new ThreadPoolExecutor(coreSize, (int)this.scheduleProperties.getMaxThreadNum(), 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(99999), new ThreadPoolExecutor.AbortPolicy());
        }

        @Bean
        public ScheduleConsumer scheduleMonitor(ScheduleConsumerClient consumerClient, DataSourceTransactionManager transactionManager, ApplicationContextHelper contextHelper, @Qualifier(value="instance") String instance, ScheduleProperties properties) {
            ScheduleConsumer scheduleConsumer = new ScheduleConsumer(this.service, instance, (PlatformTransactionManager)transactionManager, this.scheduleExecutor(), this.scheduledExecutorService(), contextHelper, properties.getPollIntervalMs());
            scheduleConsumer.setScheduleConsumerClient(consumerClient);
            return scheduleConsumer;
        }
    }
}

