/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.property;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.buildrun.seeddata.api.vo.FieldData;
import io.buildrun.seeddata.api.vo.RecordData;
import io.buildrun.seeddata.api.vo.SeedData;
import io.buildrun.seeddata.api.vo.ServiceData;
import io.buildrun.seeddata.api.vo.TableData;
import io.buildrun.seeddata.app.service.SeedDataLoader;
import io.choerodon.asgard.property.PropertyData;
import io.choerodon.asgard.property.PropertyJobTask;
import io.choerodon.asgard.property.PropertySaga;
import io.choerodon.asgard.property.PropertySagaTask;
import io.choerodon.asgard.property.PropertyTimedTask;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PropertyDataLoader
implements SeedDataLoader {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private PropertyData propertyData;

    public PropertyDataLoader(PropertyData propertyData) {
        this.propertyData = propertyData;
    }

    public List<SeedData> load() {
        SeedData seedData = new SeedData();
        ServiceData serviceData = new ServiceData();
        serviceData.setName("asgard-service");
        this.processSagas(serviceData, this.propertyData.getSagas(), this.propertyData.getService());
        this.processSagaTasks(serviceData, this.propertyData.getSagaTasks(), this.propertyData.getService());
        this.processJobTasks(serviceData, this.propertyData.getJobTasks(), this.propertyData.getService());
        this.processTimedTasks(serviceData, this.propertyData.getTimedTasks());
        seedData.getServices().add(serviceData);
        return Collections.singletonList(seedData);
    }

    void processSagas(ServiceData serviceData, List<PropertySaga> sagas, String service) {
        TableData tableData = new TableData();
        tableData.setName("asgard_orch_saga");
        for (PropertySaga saga : sagas) {
            RecordData recordData = new RecordData();
            recordData.addField(FieldData.buildForPrimary((String)"ID", null));
            recordData.addField(FieldData.buildForUnique((String)"CODE", (String)saga.getCode()));
            recordData.addField(FieldData.build((String)"SERVICE", (String)service));
            recordData.addField(FieldData.build((String)"DESCRIPTION", (String)saga.getDescription()));
            recordData.addField(FieldData.build((String)"INPUT_SCHEMA", (String)saga.getInputSchema()));
            recordData.addField(FieldData.build((String)"INPUT_SCHEMA_SOURCE", (String)saga.getInputSchemaSource()));
            tableData.getRecords().add(recordData);
        }
        serviceData.getTables().add(tableData);
    }

    void processSagaTasks(ServiceData serviceData, List<PropertySagaTask> sagaTasks, String service) {
        TableData tableData = new TableData();
        tableData.setName("asgard_orch_saga_task");
        for (PropertySagaTask task : sagaTasks) {
            RecordData recordData = new RecordData();
            recordData.addField(FieldData.buildForPrimary((String)"ID", null));
            recordData.addField(FieldData.buildForUnique((String)"CODE", (String)task.getCode()));
            recordData.addField(FieldData.build((String)"CONCURRENT_LIMIT_NUM", (String)task.getConcurrentLimitNum().toString()));
            recordData.addField(FieldData.build((String)"CONCURRENT_LIMIT_POLICY", (String)task.getConcurrentLimitPolicy()));
            recordData.addField(FieldData.buildForUnique((String)"SAGA_CODE", (String)task.getSagaCode()));
            recordData.addField(FieldData.build((String)"OUTPUT_SCHEMA", (String)task.getOutputSchema()));
            recordData.addField(FieldData.build((String)"IS_ENABLED", (String)"1").setInsertOnly(Boolean.valueOf(true)));
            recordData.addField(FieldData.buildForUnique((String)"SERVICE", (String)service));
            recordData.addField(FieldData.build((String)"SEQ", (String)task.getSeq().toString()));
            recordData.addField(FieldData.build((String)"DESCRIPTION", (String)task.getDescription()));
            recordData.addField(FieldData.build((String)"MAX_RETRY_COUNT", (String)task.getMaxRetryCount().toString()));
            recordData.addField(FieldData.build((String)"OUTPUT_SCHEMA_SOURCE", (String)task.getOutputSchemaSource()));
            tableData.getRecords().add(recordData);
        }
        serviceData.getTables().add(tableData);
    }

    void processJobTasks(ServiceData serviceData, List<PropertyJobTask> jobTasks, String service) {
        TableData tableData = new TableData();
        tableData.setName("asgard_quartz_method");
        for (PropertyJobTask task : jobTasks) {
            RecordData recordData = new RecordData();
            recordData.addField(FieldData.buildForPrimary((String)"ID", null));
            recordData.addField(FieldData.buildForUnique((String)"METHOD", (String)task.getMethod()));
            recordData.addField(FieldData.build((String)"DESCRIPTION", (String)task.getDescription()));
            recordData.addField(FieldData.build((String)"SERVICE", (String)service));
            recordData.addField(FieldData.build((String)"MAX_RETRY_COUNT", (String)Integer.toString(task.getMaxRetryCount())));
            try {
                recordData.addField(FieldData.build((String)"PARAMS", (String)MAPPER.writeValueAsString(task.getParams())));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            recordData.addField(FieldData.build((String)"FD_LEVEL", (String)task.getLevel()));
            recordData.addField(FieldData.build((String)"CODE", (String)task.getCode()));
            tableData.getRecords().add(recordData);
        }
        serviceData.getTables().add(tableData);
    }

    void processTimedTasks(ServiceData serviceData, List<PropertyTimedTask> timedTasks) {
        TableData tableData = new TableData();
        tableData.setName("asgard_quartz_task");
        for (PropertyTimedTask task : timedTasks) {
            RecordData recordData = new RecordData();
            recordData.addField(FieldData.buildForPrimary((String)"ID", null));
            recordData.addField(FieldData.buildForUnique((String)"NAME", (String)task.getName()));
            recordData.addField(FieldData.build((String)"DESCRIPTION", (String)task.getDescription()));
            recordData.addField(FieldData.build((String)"START_TIME", (String)FORMAT.format(new Date())));
            recordData.addField(FieldData.build((String)"TRIGGER_TYPE", (String)"simple-trigger"));
            recordData.addField(FieldData.build((String)"SIMPLE_REPEAT_COUNT", (String)task.getRepeatCount().toString()));
            recordData.addField(FieldData.build((String)"SIMPLE_REPEAT_INTERVAL", (String)task.getRepeatInterval().toString()));
            recordData.addField(FieldData.build((String)"SIMPLE_REPEAT_INTERVAL_UNIT", (String)task.getRepeatIntervalUnit()));
            if (task.getOneExecution().booleanValue()) {
                recordData.addField(FieldData.build((String)"CRON_EXPRESSION", (String)"1"));
            } else {
                recordData.addField(FieldData.build((String)"CRON_EXPRESSION", (String)"0"));
            }
            try {
                recordData.addField(FieldData.build((String)"EXECUTE_PARAMS", (String)MAPPER.writeValueAsString(task.getParams())));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            recordData.addField(FieldData.build((String)"EXECUTE_METHOD", (String)task.getMethodCode()));
            recordData.addField(FieldData.build((String)"FD_LEVEL", (String)"site"));
            recordData.addField(FieldData.build((String)"SOURCE_ID", (String)"0"));
            recordData.addField(FieldData.build((String)"STATUS", (String)"ENABLE").setInsertOnly(Boolean.valueOf(true)));
            tableData.getRecords().add(recordData);
        }
        serviceData.getTables().add(tableData);
    }
}

