/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.property;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.choerodon.asgard.property.PropertyData;
import io.choerodon.asgard.property.PropertyJobTask;
import io.choerodon.asgard.property.PropertySaga;
import io.choerodon.asgard.property.PropertySagaTask;
import io.choerodon.asgard.property.PropertyTimedTask;
import io.choerodon.asgard.saga.SagaDefinition;
import io.choerodon.asgard.saga.annotation.Saga;
import io.choerodon.asgard.saga.annotation.SagaTask;
import io.choerodon.asgard.saga.consumer.GenerateJsonSchemaUtil;
import io.choerodon.asgard.schedule.annotation.JobTask;
import io.choerodon.asgard.schedule.annotation.TimedTask;
import java.lang.reflect.Method;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PropertyDataProcessor
implements BeanPostProcessor {
    private final ObjectMapper mapper = new ObjectMapper();
    private PropertyData propertyData;

    public PropertyDataProcessor(PropertyData propertyData) {
        this.propertyData = propertyData;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Method[] methods;
        Saga typeSaga = (Saga)AnnotationUtils.findAnnotation(bean.getClass(), Saga.class);
        if (typeSaga != null) {
            PropertySaga data = new PropertySaga(typeSaga.code(), typeSaga.description());
            this.addInputSchema(typeSaga, data);
            this.propertyData.addSaga(data);
        }
        if ((methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass())) != null) {
            for (Method method : methods) {
                this.addMethodSaga(method);
                this.addMethodSagaTask(method);
                this.addMethodJobTask(bean, method);
            }
        }
        return bean;
    }

    private void addMethodSaga(Method method) {
        Saga saga = (Saga)AnnotationUtils.findAnnotation((Method)method, Saga.class);
        if (saga != null) {
            PropertySaga data = new PropertySaga(saga.code(), saga.description());
            this.addInputSchema(saga, data);
            this.propertyData.addSaga(data);
        }
    }

    private void addMethodSagaTask(Method method) {
        SagaTask sagaTask = (SagaTask)AnnotationUtils.findAnnotation((Method)method, SagaTask.class);
        if (sagaTask != null) {
            PropertySagaTask task = new PropertySagaTask(sagaTask.code(), sagaTask.description(), sagaTask.sagaCode(), sagaTask.seq(), sagaTask.maxRetryCount());
            task.setConcurrentLimitNum(sagaTask.concurrentLimitNum());
            task.setConcurrentLimitPolicy(sagaTask.concurrentLimitPolicy().name());
            task.setTimeoutPolicy(sagaTask.timeoutPolicy().name());
            task.setTimeoutSeconds(sagaTask.timeoutSeconds());
            this.addOutputSchema(sagaTask, method, task);
            this.propertyData.addSagaTask(task);
        }
    }

    private void addMethodJobTask(Object bean, Method method) {
        JobTask jobTask = (JobTask)AnnotationUtils.findAnnotation((Method)method, JobTask.class);
        if (jobTask != null) {
            String methodName = bean.getClass().getName() + "." + method.getName();
            this.propertyData.addJobTask(new PropertyJobTask(methodName, jobTask.maxRetryCount(), jobTask.code(), jobTask.description(), jobTask.level(), jobTask.params()));
            TimedTask timedTask = (TimedTask)AnnotationUtils.findAnnotation((Method)method, TimedTask.class);
            if (timedTask != null) {
                this.propertyData.addTimedTasks(new PropertyTimedTask(timedTask, jobTask));
            }
        }
    }

    private void addOutputSchema(SagaTask sagaTask, Method method, PropertySagaTask data) {
        if (!StringUtils.isEmpty((Object)sagaTask.outputSchema())) {
            data.setOutputSchema(sagaTask.outputSchema());
            data.setOutputSchemaSource(SagaDefinition.SagaTaskOutputSchemaSource.OUTPUT_SCHEMA.name());
        } else if (!sagaTask.outputSchemaClass().equals(Object.class)) {
            data.setOutputSchema(GenerateJsonSchemaUtil.generate(sagaTask.outputSchemaClass(), this.mapper, true));
            data.setOutputSchemaSource(SagaDefinition.SagaTaskOutputSchemaSource.OUTPUT_SCHEMA_CLASS.name());
        } else {
            data.setOutputSchema(GenerateJsonSchemaUtil.generate(method.getReturnType(), this.mapper, true));
            data.setOutputSchemaSource(SagaDefinition.SagaTaskOutputSchemaSource.METHOD_RETURN_TYPE.name());
        }
    }

    private void addInputSchema(Saga saga, PropertySaga data) {
        if (!StringUtils.isEmpty((Object)saga.inputSchema())) {
            data.setInputSchema(saga.inputSchema());
            data.setInputSchemaSource(SagaDefinition.SagaInputSchemaSource.INPUT_SCHEMA.name());
        } else if (!saga.inputSchemaClass().equals(Object.class)) {
            data.setInputSchema(GenerateJsonSchemaUtil.generate(saga.inputSchemaClass(), this.mapper, false));
            data.setInputSchemaSource(SagaDefinition.SagaInputSchemaSource.INPUT_SCHEMA_CLASS.name());
        } else {
            data.setInputSchema("");
            data.setInputSchemaSource(SagaDefinition.SagaInputSchemaSource.NONE.name());
        }
    }
}

