/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.property;

import io.choerodon.asgard.schedule.annotation.JobParam;
import io.choerodon.asgard.schedule.annotation.JobTask;
import io.choerodon.asgard.schedule.annotation.TaskParam;
import io.choerodon.asgard.schedule.annotation.TimedTask;
import io.choerodon.asgard.schedule.exception.JobParamDefaultValueParseException;
import io.choerodon.core.exception.CommonException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PropertyTimedTask {
    private String name;
    private String description;
    private Boolean oneExecution;
    private String methodCode;
    private Map<String, Object> params;
    private Integer repeatCount;
    private Long repeatInterval;
    private String repeatIntervalUnit;

    PropertyTimedTask(TimedTask timedTask, JobTask jobTask) {
        this.name = timedTask.name();
        this.description = timedTask.description();
        this.oneExecution = timedTask.oneExecution();
        this.methodCode = jobTask.code();
        this.repeatCount = timedTask.repeatCount();
        this.repeatInterval = timedTask.repeatInterval();
        this.repeatIntervalUnit = timedTask.repeatIntervalUnit().name();
        TaskParam[] taskParams = timedTask.params();
        JobParam[] jobParams = jobTask.params();
        this.params = new HashMap<String, Object>();
        for (TaskParam taskParam : taskParams) {
            JobParam jobParam2 = (JobParam)Arrays.stream(jobParams).filter(t -> t.name().equals(taskParam.name())).collect(Collectors.toList()).get(0);
            String key = taskParam.name();
            Object value = this.getValueByType(jobParam2.type(), taskParam.value());
            this.params.put(key, value);
        }
        List taskName = Arrays.stream(taskParams).map(TaskParam::name).collect(Collectors.toList());
        List collect = Arrays.stream(jobParams).filter(jobParam -> !taskName.contains(jobParam.name())).collect(Collectors.toList());
        for (JobParam jobParam3 : collect) {
            String key = jobParam3.name();
            if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(jobParam3.defaultValue())) {
                Object value = this.getValueByType(jobParam3.type(), jobParam3.defaultValue());
                this.params.put(key, value);
                continue;
            }
            throw new CommonException("error.timedTask.create.paramsValueEmpty:" + jobParam3.name(), new Object[0]);
        }
    }

    public PropertyTimedTask() {
    }

    private Object getValueByType(Class<?> type, String value) {
        try {
            return type.getConstructor(String.class).newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JobParamDefaultValueParseException(e, type, value);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getOneExecution() {
        return this.oneExecution;
    }

    public void setOneExecution(Boolean oneExecution) {
        this.oneExecution = oneExecution;
    }

    public String getMethodCode() {
        return this.methodCode;
    }

    public void setMethodCode(String methodCode) {
        this.methodCode = methodCode;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(Long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public String getRepeatIntervalUnit() {
        return this.repeatIntervalUnit;
    }

    public void setRepeatIntervalUnit(String repeatIntervalUnit) {
        this.repeatIntervalUnit = repeatIntervalUnit;
    }

    public String toString() {
        return "PropertyTimedTask{name='" + this.name + "', description='" + this.description + "', oneExecution=" + this.oneExecution + ", methodCode='" + this.methodCode + "', params=" + this.params + ", repeatCount=" + this.repeatCount + ", repeatInterval=" + this.repeatInterval + ", repeatIntervalUnit='" + this.repeatIntervalUnit + "'}";
    }
}

