/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.saga.producer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.choerodon.asgard.saga.dto.StartInstanceDTO;
import io.choerodon.asgard.saga.exception.SagaProducerException;
import io.choerodon.core.iam.ResourceLevel;
import org.springframework.util.StringUtils;

public final class StartSagaBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private StartInstanceDTO startInstanceDTO = new StartInstanceDTO();

    private StartSagaBuilder() {
    }

    public static StartSagaBuilder newBuilder() {
        return new StartSagaBuilder();
    }

    public StartSagaBuilder withSagaCode(String sagaCode) {
        this.startInstanceDTO.setSagaCode(sagaCode);
        return this;
    }

    public StartSagaBuilder withJson(String json) {
        this.startInstanceDTO.setInput(json);
        return this;
    }

    public StartSagaBuilder withPayloadAndSerialize(Object payload) {
        try {
            if (payload != null) {
                String json = MAPPER.writeValueAsString(payload);
                this.startInstanceDTO.setInput(json);
            }
        }
        catch (JsonProcessingException e) {
            throw new SagaProducerException("error.startSagaBuilder.withPayloadAndSerialize", e);
        }
        return this;
    }

    public StartSagaBuilder withRefType(String refType) {
        this.startInstanceDTO.setRefType(refType);
        return this;
    }

    public StartSagaBuilder withRefId(String refId) {
        this.startInstanceDTO.setRefId(refId);
        return this;
    }

    public StartSagaBuilder withLevel(ResourceLevel level) {
        this.startInstanceDTO.setLevel(level.value());
        return this;
    }

    public StartSagaBuilder withSourceId(Long sourceId) {
        this.startInstanceDTO.setSourceId(sourceId);
        return this;
    }

    StartSagaBuilder withService(String service) {
        this.startInstanceDTO.setService(service);
        return this;
    }

    StartSagaBuilder withUuid(String uuid) {
        this.startInstanceDTO.setUuid(uuid);
        return this;
    }

    StartInstanceDTO preBuild() {
        if (StringUtils.isEmpty((Object)this.startInstanceDTO.getSagaCode())) {
            throw new SagaProducerException("error.startSaga.sagaCodeIsEmpty");
        }
        if (this.startInstanceDTO.getLevel() == null) {
            this.startInstanceDTO.setLevel(ResourceLevel.SITE.value());
        }
        if (this.startInstanceDTO.getSourceId() == null) {
            this.startInstanceDTO.setSourceId(0L);
        }
        return this.startInstanceDTO;
    }

    StartInstanceDTO confirmBuild() {
        if (this.startInstanceDTO.getInput() == null) {
            throw new SagaProducerException("error.startSaga.inputIsNull");
        }
        if (this.startInstanceDTO.getRefId() == null || this.startInstanceDTO.getRefType() == null) {
            throw new SagaProducerException("error.startSaga.refTypeOrRefIdIsNull");
        }
        return this.startInstanceDTO;
    }
}

