/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.saga.producer.consistency;

import io.choerodon.asgard.saga.dto.SagaStatusQueryDTO;
import io.choerodon.asgard.saga.dto.StartInstanceDTO;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SagaProducerConsistencyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SagaProducerConsistencyHandler.class);
    private static final long CLEAR_INTERVAL = 86400000L;

    SagaProducerConsistencyHandler(ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                this.clear(86400000L);
            }
            catch (Exception e) {
                LOGGER.warn("error.sagaProducerConsistencyHandle.scheduleClear", (Throwable)e);
            }
        }, 2L, 60L, TimeUnit.MINUTES);
    }

    public abstract void beforeTransactionCommit(String var1, StartInstanceDTO var2);

    public abstract void beforeTransactionCancel(String var1);

    public abstract SagaStatusQueryDTO asgardServiceBackCheck(String var1);

    abstract void clear(long var1);
}

