/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.saga.producer.consistency;

import io.choerodon.asgard.saga.dto.SagaStatusQueryDTO;
import io.choerodon.asgard.saga.dto.StartInstanceDTO;
import io.choerodon.asgard.saga.producer.consistency.SagaProducerConsistencyHandler;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;

public class SagaProducerMemoryConsistencyHandler
extends SagaProducerConsistencyHandler {
    private final Map<String, StatusCache> uuidTimeMap = new ConcurrentHashMap<String, StatusCache>();

    public SagaProducerMemoryConsistencyHandler(ScheduledExecutorService executorService) {
        super(executorService);
    }

    @Override
    public void beforeTransactionCommit(String uuid, StartInstanceDTO dto) {
        this.uuidTimeMap.put(uuid, new StatusCache(System.currentTimeMillis(), dto.getInput(), dto.getRefType(), dto.getRefId()));
    }

    @Override
    public void beforeTransactionCancel(String uuid) {
        this.uuidTimeMap.remove(uuid);
    }

    @Override
    public SagaStatusQueryDTO asgardServiceBackCheck(String uuid) {
        StatusCache cache = this.uuidTimeMap.get(uuid);
        if (cache == null) {
            return new SagaStatusQueryDTO("cancel");
        }
        return new SagaStatusQueryDTO("confirm", cache.payload, cache.refType, cache.refId);
    }

    @Override
    public void clear(long time) {
        Iterator<Map.Entry<String, StatusCache>> it = this.uuidTimeMap.entrySet().iterator();
        long current = System.currentTimeMillis();
        while (it.hasNext()) {
            Map.Entry<String, StatusCache> entry = it.next();
            if (entry.getValue().time + time >= current) continue;
            it.remove();
        }
    }

    private static class StatusCache {
        final long time;
        final String payload;
        final String refType;
        final String refId;

        StatusCache(long time, String payload, String refType, String refId) {
            this.time = time;
            this.payload = payload;
            this.refType = refType;
            this.refId = refId;
        }
    }
}

