package script.db

databaseChangeLog(logicalFilePath: 'script/db/seata_undo_log.groovy') {
    changeSet(author: 'xausky@gmail.com', id: '2010-10-11-seata_undo_log') {
        createTable(tableName: "UNDO_LOG") {
            column(name: 'ID', type: 'BIGINT(20)', remarks: '主键', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: 'BRANCH_ID', type: 'BIGINT(20)') {
                constraints(nullable: false)
            }
            column(name: 'XID', type: 'VARCHAR(100)') {
                constraints(nullable: false)
            }
            column(name: 'CONTEXT', type: 'VARCHAR(128)') {
                constraints(nullable: false)
            }
            column(name: 'ROLLBACK_INFO', type: 'LONGBLOB') {
                constraints(nullable: false)
            }
            column(name: 'LOG_STATUS', type: 'INT(11)') {
                constraints(nullable: false)
            }
            column(name: 'LOG_CREATED', type: 'DATETIME') {
                constraints(nullable: false)
            }
            column(name: 'LOG_MODIFIED', type: 'DATETIME') {
                constraints(nullable: false)
            }
            column(name: 'EXT', type: 'VARCHAR(100)') {
                constraints(nullable: false)
            }
        }
        addUniqueConstraint(tableName: 'UNDO_LOG', constraintName: 'UK_UNDO_LOG', columnNames: 'XID,BRANCH_ID')
    }
}