/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.feign;

import com.google.gson.Gson;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import io.choerodon.core.oauth.CustomUserDetails;
import io.choerodon.feign.CommonProperties;
import io.choerodon.feign.RequestVariableHolder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CustomMetadataRule
extends ZoneAvoidanceRule {
    private static final String JWT_SPLIT = ".";
    private static final String HEADER_BEARER = "Bearer";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_TOKEN = "token";
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomMetadataRule.class);
    private CommonProperties commonProperties;
    private Random random = new Random();

    public void setCommonProperties(CommonProperties commonProperties) {
        this.commonProperties = commonProperties;
    }

    public Server choose(Object key) {
        this.printDebugLog("Start to choose server to route");
        List servers = this.getPredicate().getEligibleServers(this.getLoadBalancer().getAllServers(), key);
        servers.forEach(v -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("One of all servers: HOST => {}, IP => {}, Scheme => {}", new Object[]{v.getHost(), v.getPort(), v.getScheme()});
            }
        });
        if (servers.isEmpty()) {
            return null;
        }
        CustomUserDetails customUserDetails = this.getCustomUserDetails();
        if (customUserDetails == null) {
            this.printDebugLog("CustomUserDetails is Empty");
            return this.getDefaultRouteServer(servers);
        }
        if (!StringUtils.isEmpty((Object)customUserDetails.getRouteRuleCode())) {
            List ruleServers;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start to handle grayscale launching strategy, Route_Rule: {}", (Object)customUserDetails.getRouteRuleCode());
            }
            if (!(ruleServers = servers.stream().filter(server -> this.judgeRouteRuleEnable(this.extractMetadata((Server)server), customUserDetails.getRouteRuleCode())).collect(Collectors.toList())).isEmpty()) {
                this.printDebugLog("Route to specific server \u00b7\u00b7\u00b7\u00b7");
                return (Server)ruleServers.get(this.random.nextInt(ruleServers.size()));
            }
        }
        return this.getDefaultRouteServer(servers);
    }

    private CustomUserDetails getCustomUserDetails() {
        this.printDebugLog("Start to get CustomUserDetails");
        if (RequestContextHolder.getRequestAttributes() == null) {
            if (!HystrixRequestContext.isCurrentThreadInitialized()) {
                return null;
            }
            String rule = (String)RequestVariableHolder.ROUTE_RULE.get();
            if (rule == null) {
                return null;
            }
            CustomUserDetails customUserDetails = new CustomUserDetails("default", "unknown", Collections.emptyList());
            customUserDetails.setRouteRuleCode(rule);
            return customUserDetails;
        }
        Object token = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getAttribute(HEADER_TOKEN);
        String jwtToken = null;
        if (!ObjectUtils.isEmpty((Object)token)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Get CustomUserDetails: start to prase jwtToken. Token:{}", token);
            }
            jwtToken = token.toString().substring(HEADER_BEARER.length()).trim();
        } else {
            String authorization = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader(HEADER_AUTHORIZATION);
            if (ObjectUtils.isEmpty((Object)authorization)) {
                return null;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Get CustomUserDetails: start to prase jwtToken. Authorization:{}", (Object)authorization);
            }
            jwtToken = authorization.substring(HEADER_BEARER.length()).trim();
        }
        MacSigner macSigner = new MacSigner(this.commonProperties.getOauthJwtKey());
        if (!jwtToken.contains(JWT_SPLIT)) {
            return null;
        }
        String userInfo = JwtHelper.decodeAndVerify((String)jwtToken, (SignatureVerifier)macSigner).getClaims();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CustomUserDetails info, userInfo: {}", (Object)userInfo);
        }
        return (CustomUserDetails)GSON.fromJson(userInfo, CustomUserDetails.class);
    }

    private Server getDefaultRouteServer(List<Server> servers) {
        List<Server> noRuleServers = servers.stream().filter(server -> this.extractMetadata((Server)server).get("Route_Rule") == null).collect(Collectors.toList());
        noRuleServers.forEach(v -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No rule's servers: Host => {}, IP => {}, Scheme => {}", new Object[]{v.getHost(), v.getPort(), v.getScheme()});
            }
        });
        if (noRuleServers.isEmpty()) {
            this.printDebugLog("Route to one of all servers");
            return servers.get(this.random.nextInt(servers.size()));
        }
        this.printDebugLog("Route to one of no rule's servers");
        return (Server)noRuleServers.get(this.random.nextInt(noRuleServers.size()));
    }

    private boolean judgeRouteRuleEnable(Map<String, String> metadata, String routeRuleCode) {
        String sourceRouteRuleCode = metadata.get("Route_Rule");
        return sourceRouteRuleCode != null && sourceRouteRuleCode.equals(routeRuleCode);
    }

    private Map<String, String> extractMetadata(Server server) {
        return ((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata();
    }

    private void printDebugLog(String message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message);
        }
    }
}

