/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.feign;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.choerodon.core.oauth.CustomUserDetails;
import io.choerodon.feign.CommonProperties;
import io.choerodon.feign.RequestVariableHolder;
import java.util.Collections;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
public class FeignRequestInterceptor
implements RequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeignRequestInterceptor.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String OAUTH_TOKEN_PREFIX = "Bearer ";
    private Signer signer;
    private CustomUserDetails defaultUserDetails;
    private CommonProperties commonProperties;

    public FeignRequestInterceptor(CommonProperties commonProperties) {
        this.commonProperties = commonProperties;
    }

    @PostConstruct
    private void init() {
        this.signer = new MacSigner(this.commonProperties.getOauthJwtKey());
        this.defaultUserDetails = new CustomUserDetails("default", "unknown", Collections.emptyList());
        this.defaultUserDetails.setUserId(this.commonProperties.getServiceAccountId());
        this.defaultUserDetails.setOrganizationId(Long.valueOf(0L));
        this.defaultUserDetails.setLanguage("zh_CN");
        this.defaultUserDetails.setTimeZone("CCT");
    }

    public void apply(RequestTemplate template) {
        try {
            String token = null;
            if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getDetails() instanceof OAuth2AuthenticationDetails) {
                OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)SecurityContextHolder.getContext().getAuthentication().getDetails();
                if (details.getTokenType() != null && details.getTokenValue() != null) {
                    token = details.getTokenType() + " " + details.getTokenValue();
                } else if (details.getDecodedDetails() instanceof CustomUserDetails) {
                    token = OAUTH_TOKEN_PREFIX + JwtHelper.encode((CharSequence)OBJECT_MAPPER.writeValueAsString(details.getDecodedDetails()), (Signer)this.signer).getEncoded();
                }
            }
            if (token == null) {
                token = OAUTH_TOKEN_PREFIX + JwtHelper.encode((CharSequence)OBJECT_MAPPER.writeValueAsString((Object)this.defaultUserDetails), (Signer)this.signer).getEncoded();
            }
            template.header("Authorization", new String[]{token});
            this.setRouteRule(template);
        }
        catch (Exception e) {
            LOGGER.error("generate jwt token failed {}", (Throwable)e);
        }
    }

    private void setRouteRule(RequestTemplate template) {
        String rule;
        if (HystrixRequestContext.isCurrentThreadInitialized() && (rule = (String)RequestVariableHolder.ROUTE_RULE.get()) != null) {
            template.header("Route_Rule", new String[]{rule});
        }
    }
}

