/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.feign.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class EurekaMetadata {
    private ApplicationContext applicationContext;
    @Value(value="${namespace:}")
    private String envNamespace;
    public static final String K8S_NAMESPACE_FILE_PATH = "/run/secrets/kubernetes.io/serviceaccount/namespace";
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaMetadata.class);

    public EurekaMetadata(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void setRunningK8sNamespace() {
        try {
            String k8sNamespace;
            ApplicationInfoManager applicationInfoManager = (ApplicationInfoManager)this.applicationContext.getBean(ApplicationInfoManager.class);
            HashMap<String, String> appMetadata = new HashMap<String, String>();
            if (this.envNamespace != null && !"".equals(this.envNamespace)) {
                k8sNamespace = this.envNamespace;
            } else {
                k8sNamespace = this.readFileContent(K8S_NAMESPACE_FILE_PATH);
                if ("".equals(k8sNamespace)) {
                    LOGGER.warn("could not get k8s namespace: no namespace found");
                    return;
                }
            }
            appMetadata.put("namespace", k8sNamespace);
            applicationInfoManager.registerAppMetadata(appMetadata);
        }
        catch (Exception e) {
            LOGGER.warn("could not get k8s namespace: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileContent(String fileName) {
        File file = new File(fileName);
        BufferedReader reader = null;
        StringBuffer sbf = new StringBuffer();
        try {
            String tempStr;
            reader = new BufferedReader(new FileReader(file));
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr);
            }
            reader.close();
            String string = sbf.toString();
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("could not get k8s namespace: {}", (Object)e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    LOGGER.warn("could not get k8s namespace: {}", (Object)e1.getMessage());
                }
            }
        }
        return sbf.toString();
    }
}

