/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.feign.encoder;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class PageRequestQueryEncoder
implements Encoder {
    private final Encoder delegate;

    public PageRequestQueryEncoder(Encoder delegate) {
        this.delegate = delegate;
    }

    public void encode(Object object, Type type, RequestTemplate requestTemplate) throws EncodeException {
        if (object instanceof PageRequest) {
            PageRequest pageRequest = (PageRequest)object;
            requestTemplate.query("page", new String[]{pageRequest.getPageNumber() + ""});
            requestTemplate.query("size", new String[]{pageRequest.getPageSize() + ""});
            Collection existingSorts = (Collection)requestTemplate.queries().get("sort");
            ArrayList<String> sortQueries = existingSorts != null ? new ArrayList<String>(existingSorts) : new ArrayList();
            for (Sort.Order order : pageRequest.getSort()) {
                sortQueries.add(order.getProperty() + "," + order.getDirection());
            }
            requestTemplate.query("sort", sortQueries);
        } else {
            this.delegate.encode(object, type, requestTemplate);
        }
    }
}

