/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.metric;

import io.choerodon.metric.thread.ThreadStateBean;
import io.choerodon.metric.thread.ThreadStateBeanImpl;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.Collections;

@NonNullApi
@NonNullFields
public class ThreadMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;
    private ThreadStateBean threadStateBean = new ThreadStateBeanImpl();

    public ThreadMetrics() {
        this(Collections.emptyList());
    }

    public ThreadMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)"jvm.thread.NEW.sum", (Object)this.threadStateBean, ThreadStateBean::getThreadStatusNEWCount).tags(this.tags).description("thread state NEW count").register(registry);
        Gauge.builder((String)"jvm.thread.RUNNABLE.sum", (Object)this.threadStateBean, ThreadStateBean::getThreadStatusRUNNABLECount).tags(this.tags).description("thread state RUNNABLE count").register(registry);
        Gauge.builder((String)"jvm.thread.BLOCKED.sum", (Object)this.threadStateBean, ThreadStateBean::getThreadStatusBLOCKEDCount).tags(this.tags).description("thread state BLOCKED count").register(registry);
        Gauge.builder((String)"jvm.thread.WAITING.sum", (Object)this.threadStateBean, ThreadStateBean::getThreadStatusWAITINGCount).tags(this.tags).description("thread state WAITING count").register(registry);
        Gauge.builder((String)"jvm.thread.TIMEDWAITING.sum", (Object)this.threadStateBean, ThreadStateBean::getThreadStatusTIMEDWAITINGCount).tags(this.tags).description("thread state TIMED_WAITING count").register(registry);
        Gauge.builder((String)"jvm.thread.TERMINATED.sum", (Object)this.threadStateBean, ThreadStateBean::getThreadStatusTERMINATEDCount).tags(this.tags).description("thread state TERMINATED count").register(registry);
    }
}

