/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.metric.thread;

import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;

public final class ThreadUtilities {
    private static final String NULL_NAME = "Null name";
    private static ThreadGroup rootThreadGroup = null;

    private ThreadUtilities() {
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        rootThreadGroup = tg;
        return tg;
    }

    public static ThreadGroup[] getAllThreadGroups() {
        ThreadGroup root = ThreadUtilities.getRootThreadGroup();
        int nAlloc = root.activeGroupCount();
        int n = 0;
        ThreadGroup[] groups = null;
        while ((n = root.enumerate(groups = new ThreadGroup[nAlloc *= 2], true)) == nAlloc) {
        }
        ThreadGroup[] allGroups = new ThreadGroup[n + 1];
        allGroups[0] = root;
        System.arraycopy(groups, 0, allGroups, 1, n);
        return allGroups;
    }

    public static ThreadGroup getThreadGroup(String name) {
        ThreadGroup[] groups;
        if (name == null) {
            throw new NullPointerException(NULL_NAME);
        }
        for (ThreadGroup group : groups = ThreadUtilities.getAllThreadGroups()) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public static Thread[] getAllThreads() {
        ThreadGroup root = ThreadUtilities.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        Thread[] threads = null;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    public static Thread[] getGroupThreads(ThreadGroup group) {
        if (group == null) {
            throw new NullPointerException("Null group");
        }
        int nAlloc = group.activeCount();
        int n = 0;
        Thread[] threads = null;
        while ((n = group.enumerate(threads = new Thread[nAlloc *= 2], false)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    public static Thread[] getGroupThreads(String name) {
        ThreadGroup group = ThreadUtilities.getThreadGroup(name);
        if (group == null) {
            return new Thread[0];
        }
        return ThreadUtilities.getGroupThreads(group);
    }

    public static Thread[] getAllThreadsPrioritized() {
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        Arrays.sort(allThreads, (t1, t2) -> t2.getPriority() - t1.getPriority());
        return allThreads;
    }

    public static Thread[] getAllDaemonThreads() {
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        Thread[] daemons = new Thread[allThreads.length];
        int nDaemon = 0;
        for (Thread thread : allThreads) {
            if (!thread.isDaemon()) continue;
            daemons[nDaemon++] = thread;
        }
        return Arrays.copyOf(daemons, nDaemon);
    }

    public static Thread[] getAllThreads(Thread.State state) {
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        Thread[] found = new Thread[allThreads.length];
        int nFound = 0;
        for (Thread thread : allThreads) {
            if (thread.getState() != state) continue;
            found[nFound++] = thread;
        }
        return Arrays.copyOf(found, nFound);
    }

    public static Thread getThread(String name) {
        Thread[] threads;
        if (name == null) {
            throw new NullPointerException(NULL_NAME);
        }
        for (Thread thread : threads = ThreadUtilities.getAllThreads()) {
            if (!thread.getName().equals(name)) continue;
            return thread;
        }
        return null;
    }

    public static Thread getThread(long id) {
        Thread[] threads;
        for (Thread thread : threads = ThreadUtilities.getAllThreads()) {
            if (thread.getId() != id) continue;
            return thread;
        }
        return null;
    }

    public static Thread getThread(ThreadInfo info) {
        if (info == null) {
            throw new NullPointerException("Null info");
        }
        return ThreadUtilities.getThread(info.getThreadId());
    }

    public static ThreadInfo[] getAllThreadInfos() {
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        long[] ids = thbean.getAllThreadIds();
        ThreadInfo[] infos = !thbean.isObjectMonitorUsageSupported() || !thbean.isSynchronizerUsageSupported() ? thbean.getThreadInfo(ids) : thbean.getThreadInfo(ids, true, true);
        ThreadInfo[] notNulls = new ThreadInfo[infos.length];
        int nNotNulls = 0;
        for (ThreadInfo info : infos) {
            if (info == null) continue;
            notNulls[nNotNulls++] = info;
        }
        if (nNotNulls == infos.length) {
            return infos;
        }
        return Arrays.copyOf(notNulls, nNotNulls);
    }

    public static ThreadInfo getThreadInfo(String name) {
        Thread[] threads;
        if (name == null) {
            throw new NullPointerException(NULL_NAME);
        }
        for (Thread thread : threads = ThreadUtilities.getAllThreads()) {
            if (!thread.getName().equals(name)) continue;
            return ThreadUtilities.getThreadInfo(thread.getId());
        }
        return null;
    }

    public static ThreadInfo getThreadInfo(long id) {
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        if (!thbean.isObjectMonitorUsageSupported() || !thbean.isSynchronizerUsageSupported()) {
            return thbean.getThreadInfo(id);
        }
        ThreadInfo[] infos = thbean.getThreadInfo(new long[]{id}, true, true);
        if (infos.length == 0) {
            return null;
        }
        return infos[0];
    }

    public static ThreadInfo getThreadInfo(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("Null thread");
        }
        return ThreadUtilities.getThreadInfo(thread.getId());
    }

    public static Thread getLockingThread(Object object) {
        if (object == null) {
            throw new NullPointerException("Null object");
        }
        long identity = System.identityHashCode(object);
        Thread[] allThreads = ThreadUtilities.getAllThreads();
        ThreadInfo info = null;
        MonitorInfo[] monitors = null;
        for (Thread thread : allThreads) {
            info = ThreadUtilities.getThreadInfo(thread.getId());
            if (info == null) continue;
            for (MonitorInfo monitor : monitors = info.getLockedMonitors()) {
                if (identity != (long)monitor.getIdentityHashCode()) continue;
                return thread;
            }
        }
        return null;
    }

    public static Thread getBlockingThread(Thread blockedThread) {
        ThreadInfo info = ThreadUtilities.getThreadInfo(blockedThread);
        if (info == null) {
            return null;
        }
        long id = info.getLockOwnerId();
        if (id == -1L) {
            return null;
        }
        return ThreadUtilities.getThread(id);
    }
}

