/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos.helper;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.choerodon.core.nacos.GrayServiceDTO;
import io.choerodon.core.ribbon.GrayRuleCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;

public class NacosConfigClientHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosConfigClientHelper.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Value(value="${spring.cloud.nacos.config.enabled: true}")
    private boolean nacosEnabled;
    private String serverAddr;
    private String lbConfigDataId;
    private String lbConfigGroup;
    private ConfigService configService;
    private NacosConfigProperties nacosConfigProperties;
    private GrayRuleCache grayRuleCache;

    public NacosConfigClientHelper(NacosConfigProperties nacosConfigProperties, GrayRuleCache grayRuleCache) {
        this.nacosConfigProperties = nacosConfigProperties;
        this.grayRuleCache = grayRuleCache;
    }

    @PostConstruct
    private void initLbConfig() throws NacosException {
        if (this.nacosEnabled && this.nacosConfigProperties.getSharedConfigs().size() != 0) {
            NacosConfigProperties.Config lbConfig = (NacosConfigProperties.Config)this.nacosConfigProperties.getSharedConfigs().get(0);
            this.serverAddr = this.nacosConfigProperties.getServerAddr();
            this.lbConfigDataId = lbConfig.getDataId();
            this.lbConfigGroup = lbConfig.getGroup();
            this.configService = this.createConfigService();
            this.listenSharedConfig();
            this.updateCache(this.getSharedConfig());
        }
    }

    private ConfigService createConfigService() throws NacosException {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        return NacosFactory.createConfigService((Properties)properties);
    }

    public void publishSharedConfig(String content) throws NacosException {
        if (!this.nacosEnabled) {
            return;
        }
        this.configService.publishConfig(this.lbConfigDataId, this.lbConfigGroup, content);
    }

    public Map<String, List<GrayServiceDTO>> getSharedConfig() throws NacosException {
        if (!this.nacosEnabled) {
            return null;
        }
        String content = this.configService.getConfig(this.lbConfigDataId, this.lbConfigGroup, 5000L);
        return this.getGrayServices(content);
    }

    public void listenSharedConfig() throws NacosException {
        if (!this.nacosEnabled) {
            return;
        }
        this.configService.addListener(this.lbConfigDataId, this.lbConfigGroup, new Listener(){

            public Executor getExecutor() {
                return null;
            }

            public void receiveConfigInfo(String content) {
                Map<String, List<GrayServiceDTO>> configs = NacosConfigClientHelper.this.getGrayServices(content);
                NacosConfigClientHelper.this.updateCache(configs);
            }
        });
    }

    public void updateCache(Map<String, List<GrayServiceDTO>> configs) {
        if (!this.nacosEnabled) {
            return;
        }
        if (configs == null) {
            return;
        }
        this.grayRuleCache.updateConfigCache(configs);
        this.grayRuleCache.updateTreeCache(configs);
    }

    private Map<String, List<GrayServiceDTO>> getGrayServices(String content) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return null;
        }
        HashMap<String, List<GrayServiceDTO>> configs = new HashMap<String, List<GrayServiceDTO>>();
        try {
            Map oldConfigs = (Map)MAPPER.readValue(content, Map.class);
            oldConfigs.forEach((k, v) -> configs.put((String)k, (List)MAPPER.convertValue(v, (TypeReference)new TypeReference<List<GrayServiceDTO>>(){})));
        }
        catch (IOException e) {
            LOGGER.error("Convert config json error.Json Content: {}", (Object)content);
        }
        return configs;
    }
}

