/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import io.buildrun.nacos.event.NacosEventProperties;
import io.buildrun.nacos.event.listener.NacosScheduledReactor;
import io.buildrun.nacos.helper.NacosConfigClientHelper;
import io.buildrun.nacos.helper.NacosDiscoveryClientHelper;
import io.choerodon.core.ribbon.GrayRuleCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@EnableDiscoveryClient
@EnableConfigurationProperties(value={NacosEventProperties.class})
@PropertySource(value={"classpath:nacos-default.properties"})
public class CustomNacosAutoConfiguration {
    @Bean
    public NacosDiscoveryClientHelper nacosClientHelper() {
        return new NacosDiscoveryClientHelper();
    }

    @Bean
    public NacosScheduledReactor nacosServiceReactor(@Autowired NacosDiscoveryProperties nacosDiscoveryProperties, @Autowired NacosEventProperties nacosEventProperties, @Autowired NacosDiscoveryClientHelper nacosDiscoveryClientHelper) {
        return new NacosScheduledReactor(nacosDiscoveryProperties, nacosEventProperties, nacosDiscoveryClientHelper);
    }

    @Bean
    public NacosConfigClientHelper nacosConfigClientHelper(@Autowired NacosConfigProperties nacosConfigProperties, @Autowired GrayRuleCache grayRuleCache) {
        return new NacosConfigClientHelper(nacosConfigProperties, grayRuleCache);
    }

    @Bean
    @ConditionalOnMissingBean
    public NacosDiscoveryProperties nacosDiscoveryProperties() {
        return new NacosDiscoveryProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public NacosConfigProperties nacosConfigProperties() {
        return new NacosConfigProperties();
    }
}

