/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos.event.payload;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.springframework.beans.BeanUtils;

public class NacosEventPayload
extends Instance {
    private String status;
    private String version;
    private String instanceAddress;
    private String appName;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale="zh", timezone="GMT+8")
    private Date createTime;
    private static final String DEFAULT_VERSION_NAME = "unknown";

    public NacosEventPayload() {
    }

    public NacosEventPayload(Instance instance, String status) {
        BeanUtils.copyProperties((Object)instance, (Object)((Object)this));
        this.setStatus(status);
        this.instanceAddress = instance.getIp() + ":" + instance.getPort();
        this.createTime = new Date();
        this.version = instance.getMetadata().getOrDefault("BUILDRUN_IO_VERSION", DEFAULT_VERSION_NAME);
        this.appName = instance.getMetadata().getOrDefault("BUILDRUN_IO_SERVICE", (String)instance.getMetadata().get("BUILDRUN_IO_APPLICATION"));
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getInstanceAddress() {
        return this.instanceAddress;
    }

    public void setInstanceAddress(String instanceAddress) {
        this.instanceAddress = instanceAddress;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String toString() {
        return "NacosEventPayload{appName='" + this.appName + "', serviceName='" + this.getServiceName() + "', instanceId='" + this.getInstanceId() + "', ip='" + this.getIp() + "', port=" + this.getPort() + "'status='" + this.status + "', version='" + this.version + "', instanceAddress='" + this.instanceAddress + "', createTime=" + this.createTime + "}";
    }
}

