/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos;

import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClientConfiguration;
import com.alibaba.cloud.nacos.discovery.NacosWatch;
import io.buildrun.nacos.CustomNacosAutoConfiguration;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@ConditionalOnNacosDiscoveryEnabled
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class, NacosDiscoveryClientConfiguration.class, CustomNacosAutoConfiguration.class})
public class NacosDiscoveryClientAutoConfiguration {
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Bean
    @Primary
    @ConditionalOnProperty(value={"spring.cloud.nacos.discovery.watch.enabled"}, matchIfMissing=true)
    public NacosWatch nacosWatch(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties, ObjectProvider<ThreadPoolTaskScheduler> taskExecutorObjectProvider) {
        Map<String, String> envs = System.getenv();
        envs.forEach((k, v) -> {
            if (k.startsWith("BUILDRUN_IO_")) {
                nacosDiscoveryProperties.getMetadata().put(k, v);
            }
        });
        nacosDiscoveryProperties.getMetadata().put("preserved.instance.id.generator", "snowflake");
        nacosDiscoveryProperties.getMetadata().putIfAbsent("BUILDRUN_IO_APPLICATION", this.applicationName);
        nacosDiscoveryProperties.getMetadata().putIfAbsent("registration.time", String.valueOf(System.currentTimeMillis()));
        return new NacosWatch(nacosServiceManager, nacosDiscoveryProperties, taskExecutorObjectProvider);
    }
}

