/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos.dto;

import com.alibaba.cloud.nacos.NacosServiceInstance;
import java.util.Date;
import org.springframework.util.ObjectUtils;

public class NacosServiceInstanceDTO
extends NacosServiceInstance {
    public static final String ACTUATOR_ENV = "/actuator/env";
    private String serviceName;
    private String release;
    private String version;
    private int appServiceId;
    private String healthCheckUrl;
    private Date registrationTime;

    public String getServiceName() {
        if (!ObjectUtils.isEmpty((Object)this.getMetadata()) && this.getMetadata().containsKey("BUILDRUN_IO_APPLICATION")) {
            return (String)this.getMetadata().get("BUILDRUN_IO_APPLICATION");
        }
        return "UNKNOWN";
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getRelease() {
        if (!ObjectUtils.isEmpty((Object)this.getMetadata()) && this.getMetadata().containsKey("BUILDRUN_IO_RELEASE")) {
            return (String)this.getMetadata().get("BUILDRUN_IO_RELEASE");
        }
        return "UNKNOWN";
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public String getVersion() {
        if (!ObjectUtils.isEmpty((Object)this.getMetadata()) && this.getMetadata().containsKey("BUILDRUN_IO_VERSION")) {
            return (String)this.getMetadata().get("BUILDRUN_IO_VERSION");
        }
        return "UNKNOWN";
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getAppServiceId() {
        if (!ObjectUtils.isEmpty((Object)this.getMetadata()) && this.getMetadata().containsKey("BUILDRUN_IO_APP_SERVICE_ID")) {
            return Integer.parseInt((String)this.getMetadata().get("BUILDRUN_IO_APP_SERVICE_ID"));
        }
        return -1;
    }

    public void setAppServiceId(int appServiceId) {
        this.appServiceId = appServiceId;
    }

    public String getInstanceId() {
        if (!ObjectUtils.isEmpty((Object)this.getMetadata())) {
            return (String)((Object)this.getMetadata().getOrDefault("nacos.instanceId", this.getServiceId() + ":" + this.getVersion()));
        }
        return "UNKNOWN";
    }

    public void setHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
    }

    public String getHealthCheckUrl() {
        if (!ObjectUtils.isEmpty((Object)this.getMetadata())) {
            return "http://" + this.getHost() + ":" + this.getMetadata().getOrDefault("management.port", String.valueOf(this.getPort()));
        }
        return "";
    }

    public Date getRegistrationTime() {
        if (!ObjectUtils.isEmpty((Object)this.getMetadata()) && this.getMetadata().containsKey("registration.time")) {
            return new Date(Long.valueOf((String)this.getMetadata().get("registration.time")));
        }
        return new Date();
    }

    public void setRegistrationTime(Date registrationTime) {
        this.registrationTime = registrationTime;
    }
}

