/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos.event.listener;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import io.buildrun.nacos.event.NacosEventProperties;
import io.buildrun.nacos.event.observable.NacosEventObservable;
import io.buildrun.nacos.event.payload.NacosEventPayload;
import io.buildrun.nacos.helper.NacosDiscoveryClientHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class NacosScheduledReactor {
    private final Logger LOGGER = LoggerFactory.getLogger(NacosScheduledReactor.class);
    private ScheduledExecutorService executor;
    private BlockingQueue<String> servicesCache = new LinkedBlockingQueue<String>();
    private ConcurrentMap<String, List<Instance>> instancesCache = new ConcurrentHashMap<String, List<Instance>>();
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    private NamingService namingService;
    private NacosEventObservable nacosEventObservable = new NacosEventObservable();
    private NacosEventProperties nacosEventProperties;
    private NacosDiscoveryClientHelper nacosDiscoveryClientHelper;

    public NacosScheduledReactor(NacosDiscoveryProperties nacosDiscoveryProperties, NacosEventProperties nacosEventProperties, NacosDiscoveryClientHelper nacosDiscoveryClientHelper) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.nacosEventProperties = nacosEventProperties;
        this.nacosDiscoveryClientHelper = nacosDiscoveryClientHelper;
        this.namingService = nacosDiscoveryProperties.namingServiceInstance();
        if (!this.nacosEventProperties.getEnabled().booleanValue()) {
            return;
        }
        this.executor = new ScheduledThreadPoolExecutor(nacosEventProperties.getThreadCount(), r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("io.buildrun.nacos.listener");
            return thread;
        });
        this.executor.scheduleAtFixedRate(new ServiceScheduleTask(), 0L, this.nacosEventProperties.getThreadPeriod(), TimeUnit.MILLISECONDS);
    }

    private List<String> getServiceReduceList(Collection<String> list1, Collection<String> list2) {
        return list1.stream().filter(service -> !list2.contains(service)).collect(Collectors.toList());
    }

    private List<Instance> getInstanceReduceList(Collection<Instance> list1, Collection<Instance> list2) {
        ArrayList<Instance> reduceList = new ArrayList<Instance>();
        list1.forEach(service -> {
            if (!list2.stream().anyMatch(instance -> this.instanceEquals((Instance)service, (Instance)instance))) {
                reduceList.add((Instance)service);
            }
        });
        return reduceList;
    }

    private void nacosEventHandler(NamingEvent event) {
        String serviceName = event.getServiceName();
        String groupName = event.getGroupName();
        List instances = this.instancesCache.getOrDefault(serviceName, new ArrayList());
        ArrayList<Instance> allInstances = new ArrayList();
        try {
            allInstances = this.namingService.getAllInstances(serviceName, groupName);
        }
        catch (NacosException e) {
            e.printStackTrace();
        }
        if (ObjectUtils.isEmpty(allInstances)) {
            instances.forEach(instance -> this.nacosEventObservable.sendEvent(new NacosEventPayload((Instance)instance, "DOWN")));
            this.instancesCache.put(serviceName, new ArrayList());
            return;
        }
        List<Instance> reduce1 = this.getInstanceReduceList(allInstances, instances);
        reduce1.forEach(instance -> {
            this.nacosEventObservable.sendEvent(new NacosEventPayload((Instance)instance, "UP"));
            this.nacosDiscoveryClientHelper.isCurrentInstance(instance.getIp(), instance.getPort());
            this.nacosDiscoveryClientHelper.updateMetadataCache(instance.getMetadata(), instance.getInstanceId());
            instances.add(instance);
        });
        List<Instance> reduce2 = this.getInstanceReduceList(instances, allInstances);
        reduce2.forEach(instance -> {
            this.nacosEventObservable.sendEvent(new NacosEventPayload((Instance)instance, "DOWN"));
            instances.remove(instance);
        });
        this.instancesCache.put(serviceName, instances);
    }

    public NacosEventObservable getNacosEventObservable() {
        return this.nacosEventObservable;
    }

    private String getInstanceName(Instance instance) {
        return instance.getServiceName() + ":" + instance.getIp() + ":" + instance.getPort();
    }

    private Boolean instanceEquals(Instance i1, Instance i2) {
        return this.getInstanceName(i1).equals(this.getInstanceName(i2));
    }

    public class ServiceScheduleTask
    implements Runnable {
        @Override
        public void run() {
            try {
                List services = NacosScheduledReactor.this.namingService.getServicesOfServer(1, Integer.MAX_VALUE, NacosScheduledReactor.this.nacosDiscoveryProperties.getGroup()).getData();
                List<String> reduce1 = NacosScheduledReactor.this.getServiceReduceList(services, NacosScheduledReactor.this.servicesCache);
                List<String> reduce2 = NacosScheduledReactor.this.getServiceReduceList(NacosScheduledReactor.this.servicesCache, services);
                if (!ObjectUtils.isEmpty(reduce1)) {
                    reduce1.forEach(service -> {
                        try {
                            NacosScheduledReactor.this.namingService.subscribe(service, event -> {
                                if (event instanceof NamingEvent) {
                                    NacosScheduledReactor.this.nacosEventHandler((NamingEvent)event);
                                }
                            });
                            NacosScheduledReactor.this.servicesCache.add((String)service);
                        }
                        catch (NacosException e) {
                            e.printStackTrace();
                        }
                    });
                }
                if (!ObjectUtils.isEmpty(reduce2)) {
                    reduce2.forEach(service -> {
                        try {
                            NacosScheduledReactor.this.namingService.unsubscribe(service, event -> {
                                if (event instanceof NamingEvent) {
                                    NacosScheduledReactor.this.LOGGER.info("remove nacos service [{}] listener", (Object)((NamingEvent)event).getServiceName());
                                }
                            });
                            NacosScheduledReactor.this.servicesCache.remove(service);
                        }
                        catch (NacosException e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
            catch (NacosException e) {
                e.printStackTrace();
            }
        }
    }
}

