/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos.event.observable;

import io.buildrun.nacos.event.NacosEventProperties;
import io.buildrun.nacos.event.listener.NacosScheduledReactor;
import io.buildrun.nacos.event.payload.NacosEventPayload;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractNacosEventObserver
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNacosEventObserver.class);
    private final AntPathMatcher matcher = new AntPathMatcher();
    private final BlockingQueue<NacosEventPayload> eventCache = new LinkedBlockingQueue<NacosEventPayload>();
    @Autowired
    private NacosEventProperties properties;
    @Autowired
    private NacosScheduledReactor nacosScheduledReactor;

    @PostConstruct
    private void init() {
        this.nacosScheduledReactor.getNacosEventObservable().addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof NacosEventPayload) {
            NacosEventPayload payload = (NacosEventPayload)((Object)arg);
            if (Arrays.stream(this.properties.getSkipServices()).anyMatch(t -> this.matcher.match(t, payload.getServiceName()))) {
                LOGGER.info("Skip event that is skipServices, {}", (Object)payload);
                return;
            }
            if ("UP".equals(payload.getStatus())) {
                LOGGER.info("Receive UP event, payload: {}", (Object)payload);
            } else {
                LOGGER.info("Receive DOWN event, payload: {}", (Object)payload);
            }
            this.eventCache.add(payload);
            this.consumerEvent(payload);
        }
    }

    private void consumerEvent(NacosEventPayload payload) {
        if ("UP".equals(payload.getStatus())) {
            LOGGER.debug("Consumer UP event, payload: {}", (Object)payload);
            this.receiveUpEvent(payload);
        } else {
            LOGGER.debug("Consumer DOWN event, payload: {}", (Object)payload);
            this.receiveDownEvent(payload);
        }
        this.eventCache.remove((Object)payload);
    }

    public abstract void receiveUpEvent(NacosEventPayload var1);

    public abstract void receiveDownEvent(NacosEventPayload var1);

    public NacosEventProperties getProperties() {
        return this.properties;
    }

    public final void setProperties(NacosEventProperties properties) {
        this.properties = properties;
    }

    public NacosScheduledReactor getNacosServiceReactor() {
        return this.nacosScheduledReactor;
    }

    public final void setNacosServiceReactor(NacosScheduledReactor nacosScheduledReactor) {
        this.nacosScheduledReactor = nacosScheduledReactor;
    }
}

