/*
 * Decompiled with CFR 0.152.
 */
package io.buildrun.nacos.helper;

import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClient;
import io.buildrun.nacos.dto.NacosServiceInstanceDTO;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.annotation.Lazy;

public class NacosDiscoveryClientHelper {
    private Map<String, String> metadataMapCache = new ConcurrentHashMap<String, String>();
    @Value(value="${server.port}")
    private int localPort;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired(required=false)
    @Lazy
    private NacosDiscoveryClient nacosDiscoveryClient;

    public List<String> getServices() {
        return this.nacosDiscoveryClient.getServices();
    }

    public ServiceInstance getCurrentInstance() throws UnknownHostException {
        return this.getInstance(this.applicationName);
    }

    public List<NacosServiceInstanceDTO> getInstances(String serviceId) {
        List serviceInstances = this.nacosDiscoveryClient.getInstances(serviceId);
        ArrayList<NacosServiceInstanceDTO> instances = new ArrayList<NacosServiceInstanceDTO>();
        serviceInstances.forEach(serviceInstance -> {
            NacosServiceInstanceDTO instanceDTO = new NacosServiceInstanceDTO();
            BeanUtils.copyProperties((Object)serviceInstance, (Object)((Object)instanceDTO));
            instances.add(instanceDTO);
        });
        return instances;
    }

    public ServiceInstance getInstance(String serviceId) throws UnknownHostException {
        String ip = InetAddress.getLocalHost().getHostAddress();
        return this.getInstance(serviceId, ip, this.localPort);
    }

    public ServiceInstance getInstance(String serviceId, String ip, int port) throws UnknownHostException {
        List<NacosServiceInstanceDTO> instances = this.getInstances(serviceId);
        for (ServiceInstance serviceInstance : instances) {
            if (!ip.equals(serviceInstance.getHost()) || port != serviceInstance.getPort()) continue;
            return serviceInstance;
        }
        return null;
    }

    public String getInstanceId() throws UnknownHostException {
        return this.getInstanceMetadata().get("nacos.instanceId");
    }

    public String getInstanceId(ServiceInstance instance) throws UnknownHostException {
        return this.getInstanceMetadata(instance).get("nacos.instanceId");
    }

    public Map<String, String> getInstanceMetadata() throws UnknownHostException {
        return this.getInstanceMetadata(this.getInstance(this.applicationName));
    }

    public Map<String, String> getInstanceMetadata(ServiceInstance instance) {
        if (this.metadataMapCache.size() > 0) {
            return this.metadataMapCache;
        }
        return this.updateMetadataCache(instance.getMetadata(), instance.getInstanceId());
    }

    public Map<String, String> updateMetadataCache(Map<String, String> metadata, String instanceId) {
        this.metadataMapCache.clear();
        this.metadataMapCache.putAll(metadata);
        return this.metadataMapCache;
    }

    public Boolean isCurrentInstance(String ip, int port) {
        String currentIp = null;
        try {
            currentIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return currentIp.equals(ip) && this.localPort == port;
    }
}

