/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.swagger;

import com.google.common.base.Predicates;
import io.choerodon.swagger.CustomController;
import io.choerodon.swagger.exclude.EnableHandSwagger2;
import io.choerodon.swagger.notify.NotifyTemplateProcessor;
import io.choerodon.swagger.swagger.CustomSwaggerOperationPlugin;
import io.choerodon.swagger.swagger.OperationCustomPageRequestReader;
import io.choerodon.swagger.swagger.extra.ExtraDataProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Configuration
@EnableHandSwagger2
public class SwaggerConfig {
    @Value(value="${swagger.oauthUrl:http://localhost:8080/oauth/oauth/authorize}")
    private String oauthUrl;
    @Value(value="${spring.application.name}")
    private String service;

    @Bean
    public Docket docket() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(Predicates.not(requestHandler -> requestHandler.declaringClass().getName().equals("org.springframework.boot.autoconfigure.web.BasicErrorController"))).build();
    }

    @Bean
    public CustomSwaggerOperationPlugin customSwaggerOperationPlugin() {
        return new CustomSwaggerOperationPlugin();
    }

    @Bean
    public OperationCustomPageRequestReader operationCustomPageRequestReader() {
        return new OperationCustomPageRequestReader();
    }

    @Bean(value={"extraDataProcessor"})
    public ExtraDataProcessor extraDataProcessor() {
        return new ExtraDataProcessor();
    }

    @Bean(value={"notifyTemplateProcessor"})
    public NotifyTemplateProcessor notifyTemplateProcessor() {
        return new NotifyTemplateProcessor();
    }

    @Bean
    public CustomController customSwagger2Controller(JsonSerializer jsonSerializer, DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper) {
        return new CustomController(jsonSerializer, this.extraDataProcessor(), this.notifyTemplateProcessor(), documentationCache, mapper);
    }
}

