/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.swagger;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.choerodon.core.annotation.Permission;
import io.choerodon.swagger.notify.NotifyScanData;
import io.choerodon.swagger.notify.NotifyTemplateProcessor;
import io.choerodon.swagger.swagger.CustomSwagger;
import io.choerodon.swagger.swagger.ForwardedHeader;
import io.choerodon.swagger.swagger.extra.ExtraData;
import io.choerodon.swagger.swagger.extra.ExtraDataProcessor;
import io.swagger.models.Swagger;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Controller
public class CustomController {
    private static final String CUSTOM_SWAGGER_URL = "/v2/choerodon/api-docs";
    public static final String CUSTOM_NOTIFY_URL = "/choerodon/templates/notify";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private JsonSerializer jsonSerializer;
    private ExtraDataProcessor extraDataProcessor;
    private NotifyTemplateProcessor notifyTemplateProcessor;
    private DocumentationCache documentationCache;
    private ServiceModelToSwagger2Mapper mapper;
    @Value(value="${springfox.documentation.swagger.v2.host:DEFAULT}")
    private String hostNameOverride;

    public CustomController(JsonSerializer jsonSerializer, ExtraDataProcessor extraDataProcessor, NotifyTemplateProcessor notifyTemplateProcessor, DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper) {
        this.jsonSerializer = jsonSerializer;
        this.extraDataProcessor = extraDataProcessor;
        this.notifyTemplateProcessor = notifyTemplateProcessor;
        this.documentationCache = documentationCache;
        this.mapper = mapper;
    }

    public void setHostNameOverride(String hostNameOverride) {
        this.hostNameOverride = hostNameOverride;
    }

    @GetMapping(value={"/choerodon/templates/notify"}, produces={"application/json", "application/hal+json"})
    @Permission(permissionPublic=true, permissionWithin=true)
    @ResponseBody
    public ResponseEntity<NotifyScanData> getNotifyTemplates() {
        return new ResponseEntity((Object)new NotifyScanData(this.notifyTemplateProcessor.getTemplateScanData(), this.notifyTemplateProcessor.getBusinessTypeScanData()), HttpStatus.OK);
    }

    @GetMapping(value={"/v2/choerodon/api-docs"}, produces={"application/json", "application/hal+json"})
    @Permission(permissionPublic=true, permissionWithin=true)
    @ResponseBody
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        if (Strings.isNullOrEmpty((String)swagger.getHost())) {
            UriComponents uriComponents = CustomController.componentsFrom(servletRequest);
            swagger.basePath(Strings.isNullOrEmpty((String)uriComponents.getPath()) ? "/" : uriComponents.getPath());
            swagger.host(this.hostName(uriComponents));
        }
        CustomSwagger customSwagger = new CustomSwagger();
        BeanUtils.copyProperties((Object)swagger, (Object)((Object)customSwagger));
        ExtraData extraData = this.extraDataProcessor.getExtraData();
        customSwagger.setExtraData(extraData);
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)customSwagger), HttpStatus.OK);
    }

    private String hostName(UriComponents uriComponents) {
        if ("DEFAULT".equals(this.hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return this.hostNameOverride;
    }

    static UriComponents componentsFrom(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request);
        ForwardedHeader forwarded = ForwardedHeader.of(request.getHeader("Forwarded"));
        String proto = StringUtils.hasText((String)forwarded.getProto()) ? forwarded.getProto() : request.getHeader("X-Forwarded-Proto");
        String forwardedSsl = request.getHeader("X-Forwarded-Ssl");
        if (StringUtils.hasText((String)proto)) {
            builder.scheme(proto);
        } else if (StringUtils.hasText((String)forwardedSsl) && forwardedSsl.equalsIgnoreCase("on")) {
            builder.scheme("https");
        }
        String host = forwarded.getHost();
        String string = host = StringUtils.hasText((String)host) ? host : request.getHeader("X-Forwarded-Host");
        if (!StringUtils.hasText((String)host)) {
            return builder.build();
        }
        String[] hosts = StringUtils.commaDelimitedListToStringArray((String)host);
        String hostToUse = hosts[0];
        if (hostToUse.contains(":")) {
            String[] hostAndPort = StringUtils.split((String)hostToUse, (String)":");
            builder.host(hostAndPort[0]);
            builder.port(Integer.parseInt(hostAndPort[1]));
        } else {
            builder.host(hostToUse);
            builder.port(-1);
        }
        String port = request.getHeader("X-Forwarded-Port");
        if (StringUtils.hasText((String)port)) {
            builder.port(Integer.parseInt(port));
        }
        return builder.build();
    }
}

