/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.swagger.notify;

import io.choerodon.core.notify.NotifyBusinessType;
import io.choerodon.core.notify.NotifyTemplate;
import io.choerodon.swagger.notify.NotifyBusinessTypeScanData;
import io.choerodon.swagger.notify.NotifyTemplateScanData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class NotifyTemplateProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyTemplateProcessor.class);
    private final Set<NotifyTemplateScanData> templateScanData = new HashSet<NotifyTemplateScanData>(8);
    private final Set<NotifyBusinessTypeScanData> businessTypeScanData = new HashSet<NotifyBusinessTypeScanData>(8);

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        NotifyBusinessType business;
        NotifyTemplate template;
        NotifyTemplateScanData scanData;
        if (bean instanceof NotifyTemplate && this.validNotifyTemplate(scanData = new NotifyTemplateScanData((template = (NotifyTemplate)bean).businessTypeCode(), template.title(), template.content(), template.type()))) {
            this.templateScanData.add(scanData);
        }
        if ((business = (NotifyBusinessType)AnnotationUtils.findAnnotation(bean.getClass(), NotifyBusinessType.class)) != null) {
            this.businessTypeScanData.add(new NotifyBusinessTypeScanData(business.code(), business.name(), business.description(), business.level().getValue(), business.retryCount(), business.isSendInstantly(), business.isManualRetry(), business.isAllowConfig(), business.categoryCode(), business.emailEnabledFlag(), business.pmEnabledFlag(), business.smsEnabledFlag(), business.webhookEnabledFlag(), business.targetUserType(), business.notifyType().getTypeName(), business.proEmailEnabledFlag(), business.proPmEnabledFlag()));
        }
        return bean;
    }

    public Set<NotifyTemplateScanData> getTemplateScanData() {
        return this.templateScanData;
    }

    public Set<NotifyBusinessTypeScanData> getBusinessTypeScanData() {
        return this.businessTypeScanData;
    }

    private boolean validNotifyTemplate(NotifyTemplateScanData template) {
        if (StringUtils.isEmpty((Object)template.getBusinessType())) {
            LOGGER.error("error.notifyTemplate.businessTypeCodeEmpty {}", (Object)template);
            return false;
        }
        if (StringUtils.isEmpty((Object)template.getTitle())) {
            LOGGER.error("error.notifyTemplate.titleEmpty {}", (Object)template);
            return false;
        }
        if (StringUtils.isEmpty((Object)template.getContent())) {
            LOGGER.error("error.notifyTemplate.contentEmpty {}", (Object)template);
            return false;
        }
        template.setContent(this.readTemplate(template.getContent()));
        return true;
    }

    private String readTemplate(String contentPath) {
        String trimContentPath = contentPath.trim();
        if (!trimContentPath.startsWith("classpath://")) {
            return trimContentPath;
        }
        StringBuilder sb = new StringBuilder();
        trimContentPath = trimContentPath.substring(12, trimContentPath.length());
        ClassPathResource templateResource = new ClassPathResource(trimContentPath);
        try (InputStreamReader reader = new InputStreamReader(templateResource.getInputStream());
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String s;
            while ((s = bufferedReader.readLine()) != null) {
                sb.append(s).append("\n");
            }
        }
        catch (IOException e) {
            LOGGER.warn("error.NotifyTemplateProcessor.readTemplate.IOException {}", (Throwable)e);
            return trimContentPath;
        }
        return sb.toString();
    }
}

