package script.db

databaseChangeLog(logicalFilePath: 'db/devops_artifact_account.groovy') {
    changeSet(author: 'fan@choerodon.io', id: '2020-10-15-devops-artifact-account') {
        createTable(tableName: "DEVOPS_ARTIFACT_ACCOUNT", remarks: '制品库账号表') {
            column(name: 'ID', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: 'TYPE', type: 'VARCHAR(64)', remarks: '制品库账号类型，nexus,harbor') {
                constraints(nullable: false)
            }
            column(name: 'REPO_ACCOUNT', type: 'VARCHAR(64)', remarks: '制品库账号') {
                constraints(nullable: false)
            }
            column(name: 'REPO_PASSWORD', type: 'VARCHAR(64)', remarks: '制品库密码') {
                constraints(nullable: false)
            }
            column(name: 'ARTIFACT_REPO_ID', type: 'BIGINT UNSIGNED', remarks: '所属制品库 ID')
            column(name: 'DESCRIPTION', type: 'VARCHAR(255)', remarks: '制品库账号描述')
            column(name: 'PROJECT_ID', type: 'BIGINT UNSIGNED', remarks: '所属项目 ID')
            column(name: 'USER_ID', type: 'BIGINT UNSIGNED', remarks: '关联用户 ID')

            column(name: 'RULE', type: 'VARCHAR(128)', remarks: '授权角色，读，写') {
                constraints(nullable: false)
            }
            column(name: 'DEFAULT_FLAG', type: 'TINYINT UNSIGNED', defaultValue: 0, remarks: '是否是为默认制品库账号，1是/0否') {
                constraints(nullable: false)
            }
            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }

        addUniqueConstraint(tableName: 'DEVOPS_ARTIFACT_ACCOUNT', constraintName: 'UK_ARTIFACT_ACCOUNT_U1', columnNames: 'TYPE,REPO_ACCOUNT')

    }

}