package script.db

databaseChangeLog(logicalFilePath: 'db/devops_artifact_nexus_group.groovy') {
    changeSet(author: 'fan@choerodon.io', id: '2020-10-15-devops-artifact-nexus-group') {
        createTable(tableName: "DEVOPS_ARTIFACT_NEXUS_GROUP", remarks: '制品库表') {
            column(name: 'ID', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }

            column(name: 'ARTIFACT_REPO_ID', type: 'BIGINT UNSIGNED', remarks: '所属制品库 ID') {
                constraints(nullable: false)
            }

            column(name: 'MEMBER_ID', type: 'BIGINT UNSIGNED', remarks: '成员制品库 ID') {
                constraints(nullable: false)
            }
            column(name: 'SORT', type: 'TINYINT UNSIGNED', defaultValue: 0, remarks: '排序字段')
            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }

        addUniqueConstraint(tableName: 'DEVOPS_ARTIFACT_NEXUS_GROUP', constraintName: 'UK_NEXUS_GROUP_U1', columnNames: 'ARTIFACT_REPO_ID,MEMBER_ID')

    }

}