package script.db

databaseChangeLog(logicalFilePath: 'db/devops_artifact_permission.groovy') {
    changeSet(author: 'fan@choerodon.io', id: '2020-11-11-devops-artifact-permission') {
        createTable(tableName: "DEVOPS_ARTIFACT_PERMISSION", remarks: '制品库授权表') {
            column(name: 'ID', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: 'ARTIFACT_REPO_ID', type: 'BIGINT UNSIGNED', remarks: '制品库 ID') {
                constraints(nullable: false)
            }
            column(name: 'ACCOUNT_ID', type: 'BIGINT UNSIGNED', remarks: '制品库账号 ID') {
                constraints(nullable: false)
            }

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }

        addUniqueConstraint(tableName: 'DEVOPS_ARTIFACT_PERMISSION', constraintName: 'UK_ARTIFACT_PERMISSION_U1', columnNames: 'ARTIFACT_REPO_ID,ACCOUNT_ID')

    }

}