package script.db

databaseChangeLog(logicalFilePath: 'db/devops_artifact_repo.groovy') {
    changeSet(author: 'fan@choerodon.io', id: '2020-10-15-devops-artifact-repo') {
        createTable(tableName: "DEVOPS_ARTIFACT_REPO", remarks: '制品库表') {
            column(name: 'ID', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: 'NAME', type: 'VARCHAR(64)', remarks: '制品库名称') {
                constraints(nullable: false)
            }
            column(name: 'DESCRIPTION', type: 'VARCHAR(255)', remarks: '制品库描述')
            column(name: 'TYPE', type: 'VARCHAR(64)', remarks: '制品库类型，maven,npm,docker') {
                constraints(nullable: false)
            }
            column(name: 'DEFAULT_FLAG', type: 'TINYINT UNSIGNED', defaultValue: 0, remarks: '是否是为默认制品库，1是/0否') {
                constraints(nullable: false)
            }
            column(name: 'PROJECT_ID', type: 'BIGINT UNSIGNED', remarks: '所属项目 ID') {
                constraints(nullable: false)
            }

            column(name: 'NEXUS_TYPE', type: 'VARCHAR(32)', remarks: 'nexus制品库类型，hosted, group, proxy')
            column(name: 'VERSION_POLICY', type: 'VARCHAR(32)', remarks: 'nexus版本策略，RELEASE，SNAPSHOT, MIXED')
            column(name: 'WRITE_POLICY', type: 'VARCHAR(32)', remarks: 'nexus重新发布策略，ALLOW, DENY, ALLOW_ONCE')
            column(name: 'REMOTE_URL', type: 'VARCHAR(255)', remarks: 'remote地址。nexus&docker')

            column(name: 'REMOTE_AUTHENTICATION', type: 'TINYINT UNSIGNED', remarks: 'nexus remote是否需要认证，1是/0否')
            column(name: 'REMOTE_USERNAME', type: 'VARCHAR(128)', remarks: 'remote账号用户名。nexus&docker')
            column(name: 'REMOTE_PASSWORD', type: 'VARCHAR(128)', remarks: 'remote账号密码。nexus&docker')

            column(name: 'DOCKER_TYPE', type: 'VARCHAR(128)', remarks: 'docker制品库类型，hosted，remote')
            column(name: 'REMOTE_READ_ACCOUNT', type: 'TINYINT UNSIGNED', remarks: 'docker是否创建只读账号')
            column(name: 'REMOTE_READ_USERNAME', type: 'VARCHAR(128)', remarks: 'docker只读账号用户名')
            column(name: 'REMOTE_READ_PASSWORD', type: 'VARCHAR(128)', remarks: 'docker只读账号密码')

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }

        addUniqueConstraint(tableName: 'DEVOPS_ARTIFACT_REPO', constraintName: 'UK_ARTFACT_REPO_U1', columnNames: 'NAME,TYPE')

    }


    changeSet(author: 'fan@choerodon.io', id: '2020-11-18-devops-artifact-repo-add-column') {

        addColumn(tableName: 'DEVOPS_ARTIFACT_REPO') {
            column(name: 'URL', type: 'VARCHAR(256)', remarks: '制品库地址', afterColumn: 'PROJECT_ID')
            column(name: 'APP_SERVICE_ID', type: 'BIGINT UNSIGNED', remarks: '关联应用服务id', afterColumn: 'PROJECT_ID')
        }

    }
    changeSet(author: 'fan@choerodon.io', id: '2020-11-20-devops-artifact-repo-rename-column') {
        renameColumn(columnDataType: 'VARCHAR(256)', newColumnName: "NAME", oldColumnName: 'NAME', remarks: '制品库名称', tableName: 'DEVOPS_ARTIFACT_REPO')
    }

}