package script.db

databaseChangeLog(logicalFilePath: 'dba/devops_env_command_value.groovy') {
    changeSet(author: 'Younger', id: '2018-05-15-create-table') {
        createTable(tableName: "devops_env_command_value", remarks: 'command操作参数表') {
            column(name: 'id', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: 'value', type: 'TEXT', remarks: '参数')

            column(name: "object_version_number", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "created_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
    }


    changeSet(author: 'Younger', id: '2018-10-08-drop-column') {
        dropColumn(columnName: "object_version_number", tableName: "devops_env_command_value")
        dropColumn(columnName: "created_by", tableName: "devops_env_command_value")
        dropColumn(columnName: "creation_date", tableName: "devops_env_command_value")
        dropColumn(columnName: "last_updated_by", tableName: "devops_env_command_value")
        dropColumn(columnName: "last_update_date", tableName: "devops_env_command_value")
    }

}