package script.db

databaseChangeLog(logicalFilePath: 'dba/devops_gitlab_runner.groovy') {
    changeSet(author: 'xausky@163.com', id: '2020-11-06-create-table') {
        createTable(tableName: "devops_gitlab_runner", remarks: 'GitLab Runner') {
            column(name: 'id', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: 'code', type: 'VARCHAR(64)', remarks: 'Runner 编码') {
                constraints(nullable: false)
            }
            column(name: 'project_id', type: 'BIGINT UNSIGNED', remarks: '项目 ID') {
                constraints(nullable: false)
            }
            column(name: 'env_id', type: 'BIGINT UNSIGNED', remarks: '环境 ID') {
                constraints(nullable: false)
            }
            column(name: 'token', type: 'VARCHAR(40)', remarks: 'UUID Token') {
                constraints(nullable: false)
            }
            column(name: 'description', type: 'VARCHAR(255)', remarks: '说明')
            column(name: 'instance_id', type: 'BIGINT UNSIGNED', remarks: '部署的应用实例ID')
            column(name: 'pvc_id', type: 'BIGINT UNSIGNED', remarks: '关联的PVC')
            column(name: 'gitlab_runner_id', type: 'BIGINT UNSIGNED', remarks: 'GitLab Runner ID')
            column(name: 'gitlab_runner_token', type: 'VARCHAR(64)', remarks: 'GitLab Runner Token')

            column(name: "object_version_number", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "created_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
        addUniqueConstraint(tableName: 'devops_gitlab_runner', constraintName: 'DEVOPS_GITLAB_RUNNER_U1', columnNames: 'code')
    }

    changeSet(author: 'xausky@163.com', id: '2020-11-09-add-version-id') {
        addColumn(tableName: 'devops_gitlab_runner') {
            column(name: 'VERSION_ID', type: 'BIGINT UNSIGNED', remarks: '使用的APP版本')
        }
    }

    changeSet(author: 'xausky@163.com', id: '2020-11-09-update-unique'){
        dropUniqueConstraint(constraintName: "DEVOPS_GITLAB_RUNNER_U1",tableName: "devops_gitlab_runner")
        addUniqueConstraint(tableName: 'devops_gitlab_runner', constraintName: 'DEVOPS_GITLAB_RUNNER_U1', columnNames: 'code,project_id')
    }

    changeSet(author: 'xausky@163.com', id: '2020-11-12-add-fetch-time') {
        addColumn(tableName: 'devops_gitlab_runner') {
            column(name: 'LATEST_FETCH_TIME', type: 'DATETIME', remarks: 'Agent 最近拉取数据时间')
        }
    }
}