package script.db

databaseChangeLog(logicalFilePath: 'dba/devops_gitlab_runner_share.groovy') {
    changeSet(author: 'xausky@163.com', id: '2020-11-06-create-table') {
        createTable(tableName: "devops_gitlab_runner_share", remarks: 'GitLab Runner') {
            column(name: 'id', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: 'runner_id', type: 'BIGINT UNSIGNED', remarks: 'Runner ID')
            column(name: 'to_project_id', type: 'BIGINT UNSIGNED', remarks: '目标项目 ID')
            column(name: 'gitlab_runner_id', type: 'BIGINT UNSIGNED', remarks: 'GitLab Runner ID')
            column(name: 'gitlab_runner_token', type: 'VARCHAR(64)', remarks: 'GitLab Runner Token')

            column(name: "object_version_number", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "created_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
        addUniqueConstraint(tableName: 'devops_gitlab_runner_share', constraintName: 'DEVOPS_GITLAB_RUNNER_SHARE_U1', columnNames: 'runner_id, to_project_id')
    }
}