package script.db

databaseChangeLog(logicalFilePath: 'dba/devops_lc_engine.groovy') {
    changeSet(author: 'xausky', id: '2020-01-06-create-table') {
        createTable(tableName: "devops_lc_engine", remarks: '低代码引擎') {
            column(name: 'id', type: 'BIGINT UNSIGNED', remarks: '主键', autoIncrement: true) {
                constraints(primaryKey: true, primaryKeyName: 'PK_LC_ENGINE')
            }
            column(name: 'cluster_id', type: 'BIGINT UNSIGNED', remarks: '集群ID') {
                constraints(nullable: false)
            }
            column(name: 'code', type: 'VARCHAR(64)', remarks: '编码') {
                constraints(nullable: false)
            }
            column(name: 'name', type: 'VARCHAR(64)', remarks: '名称') {
                constraints(nullable: false)
            }
            column(name: 'description', type: 'VARCHAR(255)', remarks: '描述')
            column(name: 'immediately_deploy_flag', type: 'TINYINT UNSIGNED', remarks: '立即部署标记')

            column(name: "object_version_number", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "created_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }

        addUniqueConstraint(tableName: 'devops_lc_engine', constraintName: 'UK_LC_ENGINE_CODE', columnNames: 'code')
    }

    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-01-07-add-config') {
        addColumn(tableName: 'devops_lc_engine') {
            column(name: 'CONFIG', type: 'TEXT', remarks: '引擎配置信息')
            column(name: 'STATUS', type: 'VARCHAR(64)', remarks: '引擎的状态', defaultValue: "creating")
        }
    }

    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-01-07-add-command-id') {
        addColumn(tableName: 'devops_lc_engine') {
            column(name: 'COMMAND_ID', type: 'BIGINT UNSIGNED', remarks: '部署的commandId')
        }
    }

    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-01-13-add-front-url') {
        addColumn(tableName: 'devops_lc_engine') {
            column(name: 'FRONT_URL', type: 'VARCHAR(255)', remarks: '引擎的前端地址')
        }
    }

    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-04-27-add-version-registry') {
        addColumn(tableName: 'devops_lc_engine') {
            column(name: 'VERSION_ID', type: 'BIGINT UNSIGNED', remarks: '引擎使用的app版本')
            column(name: 'REGISTRY_URL', type: 'VARCHAR(255)', remarks: '引擎的注册中心地址')
        }
    }

    changeSet(author: 'xausky@163.com', id: '2020-08-26-remove-config-add-instance') {
        dropColumn(columnName: "CONFIG", tableName: "devops_lc_engine")
        addColumn(tableName: 'devops_lc_engine') {
            column(name: 'INSTANCE_ID', type: 'BIGINT UNSIGNED', remarks: '部署的应用实例ID')
        }
    }

    changeSet(author: 'xausky@163.com', id: '2020-11-04-add-env-id') {
        addColumn(tableName: 'devops_lc_engine') {
            column(name: 'ENV_ID', type: 'BIGINT UNSIGNED', remarks: '部署的环境ID')
        }
    }
}