package script.db

databaseChangeLog(logicalFilePath: 'dba/devops_lc_online_editor_config.groovy') {
    changeSet(author: 'xausky@163.com', id: '2020-08-27-create-table') {
        createTable(tableName: "devops_lc_online_editor_config", remarks: '低代码引擎') {
            column(name: 'id', type: 'BIGINT UNSIGNED', remarks: '主键', autoIncrement: true) {
                constraints(primaryKey: true, primaryKeyName: 'PK_LC_ONLINE_EDITOR_CONFIG')
            }
            column(name: 'cluster_id', type: 'BIGINT UNSIGNED', remarks: '集群ID') {
                constraints(nullable: false, unique: true)
            }
            column(name: 'version_id', type: 'BIGINT UNSIGNED', remarks: '应用版本ID') {
                constraints(nullable: false)
            }
            column(name: 'domain', type: 'VARCHAR(255)', remarks: '域名') {
                constraints(nullable: false)
            }
            column(name: 'storage_class_name', type: 'VARCHAR(255)', remarks: 'NFS Storage Class Name')

            column(name: "object_version_number", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "created_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
    }

    changeSet(author: 'xausky@163.com', id: '2020-08-27-add-source-type') {
        addColumn(tableName: 'devops_lc_online_editor_config') {
            column(name: 'SOURCE_TYPE', type: 'VARCHAR(32)', remarks: '来源类型')
        }
    }

    changeSet(author: 'xausky@163.com', id: '2020-08-28-add-service-identity') {
        addColumn(tableName: 'devops_lc_online_editor_config') {
            column(name: 'SERVICE_IDENTITY', type: 'VARCHAR(128)', remarks: '服务标识')
        }
    }
}