package script.db

databaseChangeLog(logicalFilePath: 'db/devops-maven-setting.groovy') {
    changeSet(author: 'fan@choerodon.io', id: '2020-10-15-devops-maven-setting') {
        createTable(tableName: "DEVOPS_MAVEN_SETTING", remarks: '制品库配置表') {
            column(name: 'ID', type: 'BIGINT UNSIGNED', remarks: '主键，ID', autoIncrement: true) {
                constraints(primaryKey: true)
            }
            column(name: "SOURCE_NAME", type: "VARCHAR(64)", remarks: "来源名称")
            column(name: "SOURCE_URL", type: "VARCHAR(255)", remarks: "来源地址")
            column(name: "SORT", type: 'TINYINT UNSIGNED', defaultValue: 0, remarks: '排序字段')
            column(name: "ACCOUNT", type: "VARCHAR(128)", remarks: "账号")
            column(name: "PASSWORD", type: "VARCHAR(128)", remarks: "密码")
            column(name: 'DEFAULT_FLAG', type: 'TINYINT UNSIGNED', defaultValue: 0, remarks: '是否是为系统默认配置，1是/0否') {
                constraints(nullable: false)
            }
            column(name: 'PROJECT_ID', type: 'BIGINT UNSIGNED', remarks: '所属项目id')
            column(name: 'ARTIFACT_REPO_ID', type: 'BIGINT UNSIGNED', remarks: '对应制品库id')
            column(name: 'ARTIFACT_ACCOUNT_ID', type: 'BIGINT UNSIGNED', remarks: '对应制品库账号id')

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
    }

}