package script.db

/**
 * mkt_application.groovy
 * 市场应用
 */
databaseChangeLog(logicalFilePath: 'script/db/mkt_application.groovy') {
    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-03-04-mkt_application') {
        createTable(tableName: "MKT_APPLICATION", remarks: "市场应用表") {
            column(name: 'ID', type: 'BIGINT UNSIGNED', autoIncrement: true, remarks: '表ID，主键，供其他表做外键，unsigned bigint、单表时自增、步长为 1') {
                constraints(primaryKey: true, primaryKeyName: 'PK_MKT_APPLICATION')
            }
            column(name: 'PROJECT_ID', type: 'BIGINT UNSIGNED', remarks: '所属项目ID，下载的应用项目id为0') {
                constraints(nullable: false)
            }
            column(name: 'NAME', type: 'VARCHAR(32)', remarks: '应用名称') {
                constraints(nullable: false)
            }
            column(name: 'UUID', type: 'VARCHAR(64)', remarks: '应用UUID') {
                constraints(nullable: false)
            }
            column(name: 'DESCRIPTION', type: 'VARCHAR(255)', remarks: '应用描述')
            column(name: 'IMAGE_URL', type: 'VARCHAR(1024)', remarks: '市场应用图标URL') {
                constraints(nullable: false)
            }
            column(name: 'TYPE', type: 'VARCHAR(32)', remarks: '应用类别：self_publish(自己发布的应用),from_market(应用市场下载的应用)') {
                constraints(nullable: false)
            }
            column(name: "IS_RELEASED", type: 'TINYINT UNSIGNED', defaultValue: "0", remarks: '是否已发布。0：尚未发布，默认；1：已发布。') {
                constraints(nullable: false)
            }
            column(name: 'PUBLISH_TYPE', type: 'VARCHAR(32)', defaultValue: 'mkt_deploy_only', remarks: '发布类型：' +
                    'mkt_deploy_only(默认) : 仅可部署;' +
                    'mkt_code_only : 仅可下载;' +
                    'mkt_code_deploy : 可下载也可部署') {
                constraints(nullable: false)
            }
            column(name: "IS_FREE", type: 'TINYINT UNSIGNED', defaultValue: "1", remarks: '是否免费。1(默认):免费,0:收费。') {
                constraints(nullable: false)
            }
            column(name: 'CONTRIBUTOR', type: 'VARCHAR(100)', remarks: '贡献者，一般为组织名') {
                constraints(nullable: false)
            }
            column(name: 'OVERVIEW', type: 'MEDIUMTEXT', remarks: '市场应用详细介绍')
            column(name: 'CATEGORY_CODE', type: 'VARCHAR(64)', remarks: '市场应用类别编码')
            column(name: 'CATEGORY_NAME', type: 'VARCHAR(50)', remarks: '市场应用类别名称')
            column(name: "LATEST_VERSION_ID", type: 'BIGINT UNSIGNED', remarks: '最新应用版本主键。' +
                    'IS_RELEASED=1时，即记录已发布，则表示最近发布版本；' +
                    'IS_RELEASED=0时，即记录尚未发布，则表示对应的版本。')
            column(name: 'ONLY_SERVICE', type: 'TINYINT UNSIGNED', defaultValue: "0", remarks: '是否只有一个服务，1代表是，0代表不是（由多个服务组成的应用）'){
                constraints(nullable: false)
            }

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
        addUniqueConstraint(tableName: 'MKT_APPLICATION', columnNames: 'UUID,PROJECT_ID', constraintName: 'UK_MKT_APPLICATION_U2')
        addUniqueConstraint(tableName: 'MKT_APPLICATION', columnNames: 'NAME,PROJECT_ID', constraintName: 'UK_MKT_APPLICATION_U3')
    }
    changeSet(author: 'xausky@163.com', id: '2020-06-11-remove-type-not-null'){
        dropNotNullConstraint(tableName: 'MKT_APPLICATION', columnName: 'TYPE', columnDataType: 'VARCHAR(32)')
    }
}