package script.db
/**
 * mkt_application_publish.groovy
 * 市场应用发布申请表
 */
databaseChangeLog(logicalFilePath: 'script/db/mkt_application_publish.groovy') {
    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-03-03-mkt_application_publish') {
        createTable(tableName: "MKT_APPLICATION_PUBLISH", remarks: "市场应用发布申请表") {
            column(name: 'ID', type: 'BIGINT UNSIGNED', autoIncrement: true, remarks: '表ID，主键，供其他表做外键，unsigned bigint、单表时自增、步长为 1') {
                constraints(primaryKey: true, primaryKeyName: 'PK_MKT_APPLICATION_PUBLISH')
            }
            column(name: 'PROJECT_ID', type: 'BIGINT UNSIGNED', remarks: '所属项目ID') {
                constraints(nullable: false)
            }
            column(name: 'MKT_APPLICATION_ID', type: 'BIGINT UNSIGNED', remarks: '发布的应用ID') {
                constraints(nullable: false)
            }
            column(name: 'MKT_APP_VERSION_ID', type: 'BIGINT UNSIGNED', remarks: '发布的应用版本ID') {
                constraints(nullable: false)
            }
            column(name: 'REMARK', type: 'VARCHAR(255)', remarks: '版本申请备注')
            column(name: 'NOTIFICATION_EMAIL', type: 'VARCHAR(128)', remarks: '通知邮箱') {
                constraints(nullable: false)
            }
            column(name: 'APPROVE_MESSAGE', type: 'VARCHAR(255)', remarks: '审批信息')
            column(name: 'PUBLISH_ERROR_CODE', type: 'VARCHAR(255)', remarks: '发布错误编码(仅在发布失败时有值)')

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }

        addUniqueConstraint(tableName: 'MKT_APPLICATION_PUBLISH', columnNames: 'MKT_APPLICATION_ID,MKT_APP_VERSION_ID', constraintName: 'UK_MKT_APPLICATION_PUBLISH_U1')

    }
}