package script.db
/**
 * mkt_application_service_ref.groovy
 * 应用与服务关系表
 */
databaseChangeLog(logicalFilePath: 'script/db/mkt_application_service_ref.groovy') {
    changeSet(id: '2020-03-04-mkt_application_service_ref', author: 'guokai.wu.work@gmail.com') {
        createTable(tableName: "MKT_APPLICATION_SERVICE_REF", remarks: "应用与服务关系表") {
            column(name: 'ID', type: 'BIGINT UNSIGNED', autoIncrement: true, remarks: '表ID，主键，供其他表做外键，unsigned bigint、单表时自增、步长为 1') {
                constraints(primaryKey: true, primaryKeyName: 'PK_MKT_APPLICATION_SERVICE_REF')
            }
            column(name: 'MKT_APPLICATION_ID', type: 'BIGINT UNSIGNED', remarks: '市场应用ID') {
                constraints(nullable: false)
            }
            column(name: 'DEVOPS_SERVICE_ID', type: 'BIGINT UNSIGNED', remarks: '服务ID') {
                constraints(nullable: false)
            }

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
        addUniqueConstraint(tableName: 'MKT_APPLICATION_SERVICE_REF', columnNames: 'MKT_APPLICATION_ID,DEVOPS_SERVICE_ID', constraintName: 'UK_MKT_APPLICATION_SERVICE_REF_U1')
    }
}
