package script.db
/**
 * mkt_application_svc_version_ref.groovy
 * 应用版本与服务版本关系表
 */
databaseChangeLog(logicalFilePath: 'script/db/mkt_application_svc_version_ref.groovy') {
    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-03-04-mkt_application_svc_version_ref') {
        createTable(tableName: "MKT_APPLICATION_SVC_VERSION_REF", remarks: "应用版本与服务版本关系表") {
            column(name: 'ID', type: 'BIGINT UNSIGNED', autoIncrement: true, remarks: '表ID，主键，供其他表做外键，unsigned bigint、单表时自增、步长为 1') {
                constraints(primaryKey: true, primaryKeyName: 'PK_MKT_APPLICATION_SVC_VERSION_REF')
            }
            column(name: 'MKT_APPLICATION_VERSION_ID', type: 'BIGINT UNSIGNED', remarks: '应用版本ID') {
                constraints(nullable: false)
            }
            column(name: 'DEVOPS_SERVICE_VERSION_ID', type: 'BIGINT UNSIGNED', remarks: '服务版本ID') {
                constraints(nullable: false)
            }
            column(name: 'STATUS', type: 'VARCHAR(20)', defaultValue: "unpublished", remarks: '版本状态。' +
                    "unpublished 未发布" +
                    "processing 处理中" +
                    "done 已完成" +
                    "failure 失败") {
                constraints(nullable: false)
            }

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }

        addUniqueConstraint(tableName: 'MKT_APPLICATION_SVC_VERSION_REF', columnNames: 'MKT_APPLICATION_VERSION_ID, DEVOPS_SERVICE_VERSION_ID', constraintName: 'UK_MKT_APPLICATION_SVC_VERSION_REF_U1')
    }
}