package script.db
/**
 * mkt_application_version.groovy
 * 市场应用版本表
 */
databaseChangeLog(logicalFilePath: 'script/db/mkt_application_version.groovy') {
    changeSet(author: 'guokai.wu.work@gmail.com', id: '2020-03-03-mkt_application_version') {
        createTable(tableName: "MKT_APPLICATION_VERSION", remarks: "市场应用版本表") {
            column(name: 'ID', type: 'BIGINT UNSIGNED', autoIncrement: true, remarks: '表ID，主键，供其他表做外键，unsigned bigint、单表时自增、步长为 1') {
                constraints(primaryKey: true, primaryKeyName: 'PK_FD_APPLICATION_VERSION')
            }
            column(name: 'MKT_APPLICATION_ID', type: 'BIGINT UNSIGNED', remarks: '应用ID') {
                constraints(nullable: false)
            }
            column(name: 'VERSION', type: 'VARCHAR(64)', remarks: '版本名称') {
                constraints(nullable: false)
            }
            column(name: 'DESCRIPTION', type: 'VARCHAR(5000)', remarks: '版本说明')
            column(name: 'STATUS', type: 'VARCHAR(20)', defaultValue: "unpublished", remarks: '版本状态。' +
                    'unpublished(默认):未发布;' +
                    'withdrawn:已撤销;' +
                    'rejected:被驳回;' +
                    'under_approval:审批中;' +
                    'unconfirmed:待最后确认的;' +
                    'published:已发布') {
                constraints(nullable: false)
            }
            column(name: 'CHANGELOG', type: 'TEXT', remarks: '版本日志')
            column(name: 'DOCUMENT', type: 'TEXT', remarks: '文档')
            column(name: "PUBLISH_DATE", type: "DATETIME", remarks: '版本的发布时间')
            column(name: 'TIMES_OF_FIXES', type: 'INT UNSIGNED', remarks: '发布修复版本的次数', defaultValue: 0) {
                constraints(nullable: false)
            }

            column(name: "OBJECT_VERSION_NUMBER", type: "BIGINT UNSIGNED", defaultValue: "1")
            column(name: "CREATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "CREATION_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
            column(name: "LAST_UPDATED_BY", type: "BIGINT UNSIGNED", defaultValue: "0")
            column(name: "LAST_UPDATE_DATE", type: "DATETIME", defaultValueComputed: "CURRENT_TIMESTAMP")
        }
        addUniqueConstraint(tableName: 'MKT_APPLICATION_VERSION', columnNames: 'MKT_APPLICATION_ID, VERSION', constraintName: 'UK_MKT_APPLICATION_VERSION_U1')
    }
    changeSet(author: 'xausky@163.com', id: '2020-06-11-add-type'){
        addColumn(tableName: 'MKT_APPLICATION_VERSION') {
            column(name: 'TYPE', type: 'VARCHAR(32)', remarks: '应用类别：self_publish(自己发布的应用),from_market(应用市场下载的应用)')
        }
    }
}