package script.nexus

import groovy.json.JsonSlurper
import org.sonatype.nexus.repository.Repository
import org.sonatype.nexus.repository.manager.RepositoryManager

def param = new JsonSlurper().parseText(args)
println "Group Name $param.name"
println "Group Members: $param.group.memberNames"

RepositoryManager repositoryManager = repository.repositoryManager

Repository existingRepository = repositoryManager.get(param.name)

if (existingRepository != null) {
    newConfig = existingRepository.configuration.copy()
    newConfig.attributes['group']['memberNames'] = param.group.memberNames

    repositoryManager.update(newConfig)
} else {
    repository.createMavenGroup(param.name, param.group.memberNames, param.storage.blobStoreName)
}