#!/usr/bin/env bash
MAVEN_LOCAL_REPO=$(cd / && mvn help:evaluate -Dexpression=settings.localRepository -q -DforceStdout)
TOOL_GROUP_ID=io.buildrun
TOOL_ARTIFACT_ID=buildrun-tool-liquibase
TOOL_VERSION=1.2.1.RELEASE
TOOL_JAR_PATH=${r'${MAVEN_LOCAL_REPO}/${TOOL_GROUP_ID/\./\/}/${TOOL_ARTIFACT_ID}/${TOOL_VERSION}/${TOOL_ARTIFACT_ID}-${TOOL_VERSION}.jar'}
mvn org.apache.maven.plugins:maven-dependency-plugin:get \
 -Dartifact=${r'${TOOL_GROUP_ID}:${TOOL_ARTIFACT_ID}:${TOOL_VERSION}'} \
 -Dtransitive=false

java -Dspring.datasource.url="${datasourceUrl}" \
 -Dspring.datasource.username=${datasourceUsername} \
 -Dspring.datasource.password=${datasourcePassword} \
 -Ddata.jar=target/app.jar \
 -jar ${r'${TOOL_JAR_PATH}'}