import React, { Fragment, useMemo } from 'react';
import { inject } from 'mobx-react';
import { ModalContainer } from 'choerodon-ui/pro';
import { withRouter } from 'react-router-dom';
import { Route, Switch, nomatch } from '@buildrun/boot';
import { asyncLocaleProvider, asyncRouter } from '@buildrun/utils';

const Product = asyncRouter(() => import('./routes/product'));

const Index = inject('AppState')((props) => {
  const { match, AppState: { currentLanguage: language } } = props;
  const IntlProviderAsync = useMemo(() => asyncLocaleProvider(language, () => import(`./locale/${language}`)), [language]);
  return (
    <IntlProviderAsync>
      <Fragment>
        <Switch>
          <Route path={`${match.url}/product`} component={Product} />
          <Route path="*" component={nomatch} />
        </Switch>
        <ModalContainer />
      </Fragment>
    </IntlProviderAsync>
  );
});

export default withRouter(Index);
