import React from 'react';
import { observer } from 'mobx-react-lite';
import { Form, TextField, TextArea } from 'choerodon-ui/pro';

export default observer((props) => {
  const { modal, listDataSet } = props;

  async function handleOk() {
    try {
      if (await listDataSet.submit()) {
        await listDataSet.query();
      } else {
        return false;
      }
    } catch (err) {
      return false;
    }
  }

  modal.handleOk(() => handleOk());
  modal.handleCancel(() => {
    listDataSet.reset();
  });

  return (
    <div>
      <Form dataSet={listDataSet}>
        <TextField name="name" />
        <TextArea name="description" />
      </Form>
    </div>
  );
});
