import React, { useContext, useMemo } from 'react';
import { observer } from 'mobx-react-lite';
import { Content, TabPage } from '@buildrun/boot';
import { Table, Modal, Button } from 'choerodon-ui/pro';
import Store from './stores';
import FormView from './FormView';

import './index.less';

const modalKey = Modal.key();
const { Column } = Table;

function ListView() {
  const { intl, listDataSet, prefixCls, intlPrefix } = useContext(Store);
  const modalStyle = useMemo(() => ({ width: 380 }), []);

  function refresh() {
    listDataSet.query();
  }

  function openModal(type) {
    Modal.open({
      title: intl.formatMessage({ id: `${r'${intlPrefix}.${type}'}` }),
      children: (
        <FormView
          listDataSet={listDataSet}
        />
      ),
      key: modalKey,
      drawer: true,
      style: modalStyle,
      destroyOnClose: true,
    });
  }

  function handleModify(record) {
    listDataSet.current = record;
    openModal('modify');
  }

  function handleCreate() {
    listDataSet.create();
    openModal('create');
  }

  function renderName({ record, text }) {
    return <span className="link" onClick={() => handleModify(record)}>{text}</span>;
  }

  const commands = ({ record }) => [
    'delete',
  ];

  function renderCreateBtn() {
    return (
      <Button funcType="flat" color="primary" icon="playlist_add" onClick={handleCreate}>
        {intl.formatMessage({ id: 'create' })}
      </Button>
    );
  }

  function renderRefreshBtn() {
    return (
      <Button funcType="flat" color="primary" icon="refresh" onClick={refresh}>
        {intl.formatMessage({ id: 'refresh' })}
      </Button>
    );
  }

  const buttons = [
    renderCreateBtn(),
    renderRefreshBtn(),
  ];

  return (
    <TabPage>
      <Content className={prefixCls}>
        <Table
          labelLayout="float"
          pristine
          dataSet={listDataSet}
          buttons={buttons}
          header="产品"
          queryBar="none"
        >
          <Column name="name" renderer={renderName} />
          <Column name="description" />
          <Column header="操作" width={150} command={commands} lock="right" />
        </Table>
      </Content>
    </TabPage>
  );
}

export default observer(ListView);
