export default ({ intlPrefix, intl }) => {
  const url = '/${routeCode}/v1/product';
  const name = intl.formatMessage({ id: `${r'${intlPrefix}'}.name` });
  const description = intl.formatMessage({ id: `${r'${intlPrefix}'}.description` });

  return {
    autoQuery: true,
    selection: false,
    transport: {
      read: {
        url,
        method: 'get',
      },
      create: ({ data: [data] }) => ({
        url,
        method: 'post',
        data,
      }),
      update: ({ data: [data] }) => ({
        url,
        method: 'put',
        data,
      }),
      destroy: ({ data: [data] }) => ({
        url: `${r'${url}/${data.id}'}`,
        method: 'delete',
      }),
    },
    fields: [
      { name: 'id', type: 'string', label: 'ID' },
      { name: 'name', type: 'string', label: name, required: true },
      { name: 'description', type: 'string', label: description },
    ],
  };
};
