import React, { createContext, useMemo } from 'react';
import { DataSet } from 'choerodon-ui/pro';
import { inject } from 'mobx-react';
import { injectIntl } from 'react-intl';
import ListDataSet from './DataSet';

const Store = createContext();

export default Store;

export const StoreProvider = injectIntl(inject('AppState')(
  (props) => {
    const {
      intl,
      children,
    } = props;
    const intlPrefix = 'product';
    const prefixCls = 'product';
    const listDataSet = useMemo(() => new DataSet(ListDataSet({ intlPrefix, intl })));
    const value = {
      ...props,
      intlPrefix,
      prefixCls,
      listDataSet,
    };

    return (
      <Store.Provider value={value}>
        {children}
      </Store.Provider>
    );
  },
));
