package ${packageName}.api.controller.v1;

import ${packageName}.app.service.ProductService;
import ${packageName}.infra.dto.Product;
import com.github.pagehelper.PageInfo;
import io.choerodon.core.annotation.Permission;
import io.choerodon.core.enums.ResourceType;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/v1/product")
public class ProductController {

    private ProductService productService;

    public ProductController(ProductService productService) {
        this.productService = productService;
    }

    @GetMapping
    @Permission(type = ResourceType.SITE)
    @ApiOperation("分页查询产品列表")
    public PageInfo<Product> select(Pageable pageable) {
        return productService.select(pageable);
    }

    @PostMapping
    @Permission(type = ResourceType.SITE)
    @ApiOperation("创建产品")
    public Product create(Product product) {
        return productService.create(product);
    }

    @PutMapping
    @Permission(type = ResourceType.SITE)
    @ApiOperation("更新产品")
    public Product update(Product product) {
        return productService.update(product);
    }

    @DeleteMapping("/{id}")
    @Permission(type = ResourceType.SITE)
    @ApiOperation("删除产品")
    public Product delete(@PathVariable Integer id) {
        return productService.delete(id);
    }

}
